;; -*- Scheme -*-
;;
;; $Id: stringt57.scm,v 1.3 1993/10/26 22:40:48 bevan Exp $

(require 'string:search)
(require 'string:test:equal)
(require 'char-set:whitespace)


(define string:test:search
  (lambda args
    (let* ((y (lambda (_ . r) r))
	   (n (lambda (r) #f))
	   (search (lambda (s . ops) (apply string:search s y n ops)))
	   (find string:search:find)
	   (match string:search:match)
	   (skip* string:search:skip*)
	   (skip+ string:search:skip+)
	   (save-string string:search:save-string)
	   (save-pos string:search:save-pos)
	   (ws char-set:whitespace))
      
      
      (if (not (null? args)) (display "Testing string:search ... "))

      (string:test:equal
       'string:test:search-a
       (search "#include" (match "#") (skip* ws) (match "include"))
       '())

      (string:test:equal
       'string:test:search-b
       (search "#includ" (match "#") (skip* ws) (match "include"))
       #f)

      (string:test:equal
       'string:test:search-c
       (search "#    include" (match "#") (skip* ws) (match "include"))
       '())

      (string:test:equal
       'string:test:search-d
       (search "#    include" (match "#") (skip+ ws) (match "include"))
       '())

      (string:test:equal
       'string:test:search-e
       (search "#include" (match "#") (skip+ ws) (match "include"))
       #f)

      (string:test:equal
       'string:test:search-f
       (search
	"#include \"foo.h\""
	(match #\#) (skip* ws) (match "include") (skip* ws)
	(match #\") (find #\"))
       '())

      (string:test:equal
       'string:test:search-g
       (search
	"#include \"foo.h\""
	(match #\#) (skip* ws) (match "include") (skip* ws)
	(match #\")
	(save-pos)
	(find #\")
	(save-pos))
       '(15 10))

      (string:test:equal
       'string:test:search-h
       (search
	"#include \"foo.h\""
	(match #\#)
	(skip* ws)
	(match "include")
	(skip* ws)
	(match #\")
	(save-string
	 (find #\")))
       '("foo.h"))

      (string:test:equal
       'string:test:search-i
       (search
	"#include \"foo.h\""
	(match #\#) (skip* ws) (match "include") (skip* ws) (match #\")
	(save-string (find #\.) (save-pos) (find #\")))
       '("foo.h" 13))

      (string:test:equal
       'string:test:search-j
       (search
	"#include \"foo.h\""
	(match #\#) (skip* ws) (match "include") (skip* ws) (match #\")
	(save-string (save-string (find #\.)) (find #\")))
       '("foo.h" "foo"))

      (if (not (null? args)) (begin (display "done") (newline)))

      )))

;; eof
