; -*- Scheme -*-
;
; $Id$

(require 'string:test:equal)
(require 'substring:find-balanced-chars)
(require 'string->char-set)

(define substring:test:find-balanced-chars
  (lambda ()

    (string:test:equal
     'substring:find-balanced-chars-a
     (let ((str "((2*x)+3)+(5*y)"))
       (substring:find-balanced-chars
	  str
	  0
	  (string-length str)
	  (string->char-set "(")
	  (string->char-set "+")
	  (string->char-set ")")
	  (lambda (p k r) p)
	  (lambda (r) #f)
	  'dummy-argument))
     9)

    (string:test:equal
     'substring:find-balanced-chars-b
     (let ((str "[+,[2,3]],[*,[5,10]]"))
       (substring:find-balanced-chars 
	  str
	  0
	  (string-length str)
	  (string->char-set "[")
	  (string->char-set ",")
	  (string->char-set "]")
	  (lambda (p k r) p)
	  (lambda (r) #f)
	  'dummy-argument))
     9)

    (string:test:equal
     'substring:find-balanced-chars-c
     (let ((str "([a+b))+c]"))
       (substring:find-balanced-chars
	  str
	  0
	  (string-length str)
	  (string->char-set "([")
	  (string->char-set "+")
	  (string->char-set "])")
	  (lambda (p k r) p)
	  (lambda (r) #f)
	  'dummy-argument))
     7)

  ))

; eof
