;; -*- Scheme -*-
;;
;; $Id: stringt01.scm,v 1.3 1993/10/26 22:42:49 bevan Exp $

;;------------

(require 'substring:test:replicate!)
(require 'substring:test:center!)
(require 'substring:test:capitalize!)
(require 'string:test:capitalize!)
(require 'string:test:split-by-string-ignoring-ends)
(require 'string:test:split-by-string)
(require 'substring:test:center)
(require 'string:test:center)
(require 'string:test:icon:center)
(require 'string:test:replicate)
(require 'substring:test:downcase!)
(require 'substring:test:downcase)
(require 'string:test:translate)
(require 'string:test:reverse)
(require 'string:test:pad-left)
(require 'substring:test:find-balanced-chars)
(require 'string:test:split-by-whitespace)
(require 'substring:test:upcase)
(require 'substring:test:center-with-padding!)
(require 'string:test:trim-right-by-proc)
(require 'string:test:trim-left-by-proc)
(require 'string:test:trim-right)
(require 'string:test:trim-by-proc)
(require 'string:test:trim)
(require 'substring:test:prefix?)
(require 'string:test:search)
(require 'string:test:case)

;------------

;;+doc
;; procedure: string:test
;; arguments: none
;; signature: () -> unspecified
;; 
;; Applies all the regression tests for various string processing functions
;; If a test fails, a message should be printed indicating which test.
;; There will be no output if all the tests pass.
;;-doc

(define string:test
  (lambda args
    (apply substring:test:replicate! args)
    (apply substring:test:center! args)
    (substring:test:capitalize!)
    (string:test:capitalize!)
    (apply string:test:split-by-string-ignoring-ends args)
    (apply string:test:split-by-string args)
    (apply substring:test:center args)
    (apply string:test:center args)
    (string:test:icon:center)
    (substring:test:replicate)
    (string:test:replicate)
    (apply substring:test:downcase! args)
    (substring:test:downcase)
    (string:test:translate)
    (string:test:reverse)
    (string:test:pad-left)
    (substring:test:find-balanced-chars)
    (string:test:split-by-whitespace)
    (apply substring:test:upcase args)
    (substring:test:center-with-padding!)
    (string:test:trim-right-by-proc)
    (string:test:trim-left-by-proc)
    (string:test:trim-right)
    (string:test:trim-by-proc)
    (apply string:test:trim args)
    (apply substring:test:prefix? args)
    (apply string:test:search args)
    (apply string:test:case args)
    ))

;; eof
