; -*- Scheme -*-
;
; $Id: string51.scm,v 1.1 1993/08/28 12:27:16 bevan Exp $

(require 'substring:trim-right-pos-with-char)
(require 'substring:trim-left-pos-with-char)

;+doc
; procedure: string:trim-with-char
; arguments: string chars
; signature: string x char-set -> string
;
; Trims CHARS off both ends of STRING and return the new string.
;
; > (string:trim-with-char "   abcd efgh   " #\space)
; "abcd efgh"
; > (string:trim-with-char "     " #\space)
; ""
;-doc

(define string:trim-with-char
  (lambda (s cs)
    (let ((sl (string-length s)))
      (let ((l (substring:trim-left-pos-with-char s 0 sl cs)))
	(if (= l sl)
	    ""
	   (let ((r (substring:trim-right-pos-with-char s l sl cs)))
	     (substring s l r)))))))

; eof
