; -*- Scheme -*-
;
; $Id: string33.scm,v 1.1 1993/08/28 12:25:08 bevan Exp $

;+doc
; procedure: string:split-by-char-no-dups
; arguments: string char 
; signature: string x char -> list[string]
;
; Returns a list of words delimited by CHAR in STRING.
; If STRING is empty or contains only CHAR, then the
; empty list is returned
;
; This is based on the split function in Python, which I believe is
; based on the Perl/Awk one.
;
; > (string:split-by-char-no-dups ":abc:d:e:f:" #\:)
; ("abc" "d" "e" "f")
;
; > (string:split-by-char-no-dups "::abc:d:::e:f:" #\:)
; ("abc" "d" "e" "f")
;
; > (string:split-by-char-no-dups "" #\:)
; ()
;
; > (string:split-by-char-no-dups "a" #\:)
; ("a")
;-doc

(define string:split-by-char-no-dups
  (lambda (s c)
    (let ((result '()) (sl (string-length s)))
      (if (zero? sl)
	  result
	  (let loop ((s s) (sp sl) (r result))
	    (let ((nwp (string::skip-char s c sp)))
	      (if (zero? nwp)
		  r
		  (let* ((nsp (string::skip-non-char s c nwp))
			 (nr (cons (substring s nsp nwp) r)))
		    (if (zero? nsp) nr (loop s (- nsp 1) nr))))))))))


; This could be written in terms of STRING:FIND-CHARS, but don't
; bother unless you can manage to make it tail recursive like the
; above.

;-------------

(define string::skip-char
  (lambda (s c i)
    (cond
     ((zero? i) i)
     ((char=? c (string-ref s (- i 1))) (string::skip-char s c (- i 1)))
     (else i))))
    
(define string::skip-non-char
  (lambda (s c i)
    (cond
     ((zero? i) i)
     ((char=? c (string-ref s (- i 1))) i)
     (else (string::skip-non-char s c (- i 1))))))

; eof
