; -*- Scheme -*-
;
; $Id: string21.scm,v 1.1 1993/08/28 12:23:09 bevan Exp $

(require 'substring:find-by-knuth-morris-pratt)
(require 'string:find-by-knuth-morris-pratt)

;+doc
; procedure: substring:find-string
; arguments: pattern string start end if-found if-not-found state
; signature: substring-searcher
;  where
;    substring-searcher = 
;      forall a
;        => string
;        -> (string x int x int x (int x (a -> a) x a -> a) x (a -> a) x a)
;        -> a
;
; Searches for PATTERN in STRING starting at position START and ending
; at position END.  Each time PATTERN is found, IF-FOUND is called
; with the position of the first character of PATTERN a continuation
; representing any subsequent PATTERN positions and a STATE.  If
; PATTERN is not found, then IF-NOT-FOUND is called with the STATE at
; that point.
;
;-doc

(define substring:find-string substring:find-by-knuth-morris-pratt)

; An arbitrary choice.

;------------

;+doc
; procedure: string:find-string
; arguments: pattern string if-found if-not-found state
;
; Equivalent to SUBSTRING:FIND-STRING with a START of 0 and an
; END of (STRING-LENGTH SOURCE)
;-doc

(define string:find-string string:find-by-knuth-morris-pratt)

; eof
