#| -*-Scheme-*-

$Header$

Copyright (c) 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Nogood Set Operations

(declare (usual-integrations)
	 (integrate-external "struct"))

(define (form-nogood-set! cells)
  (ctrace "The set"
	  ($map " " ", " ""
		(lambda (cell)
		  ($nested ($literal (cell/good-name cell))
			   "="
			   ($literal (cell/value cell))))
		cells)
	  " is no good.")
  (install-nogood-set!
   (map (lambda (cell)
	  (cons (cell/repository cell) (cell/value cell)))
	cells)))

(define (install-nogood-set! alist)
  (let ((alist (sort alist (lambda (x y) (repository<? (car x) (car y))))))
    (let ((nogood (cons 'NOGOOD alist)))
      (for-each (lambda (pair)
		  (let ((repository (car pair))
			(value (cdr pair)))
		    (let ((nogoods (repository/nogoods repository)))
		      (let ((slot (nogood-assoc value nogoods)))
			(cond (slot
			       (if (not
				    (list-search-positive (cdr slot)
				      (lambda (x)
					(nogood=? x nogood))))
				   (set-cdr! slot (cons nogood (cdr slot)))))
			      ((or (null? nogoods)
				   (value<? value (caar nogoods)))
			       (set-repository/nogoods!
				repository
				(cons (list value nogood) nogoods)))
			      (else
			       (let loop ((nogoods nogoods))
				 (if (or (null? (cdr nogoods))
					 (value<? value (caar (cdr nogoods))))
				     (set-cdr! nogoods
					       (cons (list value nogood)
						     (cdr nogoods)))
				     (loop (cdr nogoods))))))))))
		alist))))

(define (nogood=? x y)
  (let loop ((x (cdr x)) (y (cdr y)))
    (if (null? x)
	(null? y)
	(and (not (null? y))
	     (eq? (caar x) (caar y))
	     (value=? (cdar x) (cdar y))
	     (loop (cdr x) (cdr y))))))

(define (nogood-assoc value nogoods)
  (list-search-positive nogoods
    (lambda (nogood)
      (value=? (car nogood) value))))

(define (alter-nogoods-repository! r* r)
  (mapcan
   (lambda (bucket)
     (mapcan
      (lambda (nogood)
	(let ((z (assq r (cdr nogood)))
	      (z* (assq r* (cdr nogood))))
	  (cond ((not z)
		 (set-cdr! nogood
			   (add-nogood-pair! r
					     (cdr z*)
					     (delq! z* (cdr nogood))))
		 '())
		((value=? (cdr z) (cdr z*))
		 (set-cdr! nogood (delq! z* (cdr nogood)))
		 '())
		(else
		 (mapcan
		  (lambda (pair)
		    (let ((repository (car pair)))
		      (let ((cells (repository/cells repository))
			    (nogoods (repository/nogoods repository)))
			(let ((bucket (nogood-assoc (cdr pair) nogoods)))
			  (let ((new-cdr (delq! nogood (cdr bucket))))
			    (if (null? new-cdr)
				(set-repository/nogoods!
				 repository
				 (delq! bucket nogoods))
				(set-cdr! bucket new-cdr))))
			(list-copy cells))))
		  (cdr nogood))))))
      (cdr bucket)))
   (repository/nogoods r*)))

(define (add-nogood-pair! repository value pairs)
  (if (or (null? pairs)
	  (repository<? repository (caar pairs)))
      (cons (cons repository value) pairs)
      (begin
	(let loop ((tail pairs))
	  (let ((pairs (cdr pairs)))
	    (if (or (null? pairs)
		    (repository<? repository (caar pairs)))
		(set-cdr! tail (cons (cons repository value) pairs))
		(loop pairs))))
	pairs)))

(define (merge-nogood-sets x y)
  (cond ((null? x) y)
	((null? y) x)
	((value<? (caar x) (caar y))
	 (cons (car x) (merge-nogood-sets (cdr x) y)))
	((value<? (caar y) (caar x))
	 (cons (car y) (merge-nogood-sets x (cdr y))))
	(else
	 (cons (cons (caar x)
		     (let ((y (cdar y)))
		       (append! (list-transform-negative (cdar x)
				  (lambda (nogood)
				    (list-search-positive y
				      (lambda (nogood*)
					(nogood=? nogood nogood*)))))
				y)))
	       (merge-nogood-sets (cdr x) (cdr y))))))

(define (forbidden? node value)
  (list-search-positive
      (let ((association (nogood-assoc value (node/nogoods node))))
	(if association
	    (cdr association)
	    '()))
    (let ((repository (cell/repository node)))
      (lambda (nogood)
	(for-all? (cdr nogood)
	  (lambda (c)
	    (or (eq? (car c) repository)
		(let ((supplier (repository/supplier (car c))))
		  (and (cell/king? supplier)
		       (value=? (cell/contents supplier) (cdr c)))))))))))

(define (choose-from node values)
  (let loop ((v values) (killers '()))
    (if (not (null? v))
	(let ((nogood (forbidden? node (car v))))
	  (if nogood
	      (loop (cdr v) (cons nogood killers))
	      (car v)))
	(begin
	  (signal-nochoice! values node killers)
	  rule-result:dismiss))))

(define (resolve-among node values)
  (let loop ((values values) (killers '()) (winners '()))
    (cond ((not (null? values))
	   (let ((nogood (forbidden? node (car values))))
	     (if nogood
		 (loop (cdr values) (cons nogood killers) winners)
		 (loop (cdr values) killers (cons (car values) winners)))))
	  ((null? winners)
	   (signal-nochoice! values node killers)
	   rule-result:dismiss)
	  ((null? (cdr winners))
	   (car winners))
	  (else
	   rule-result:dismiss))))

(define (signal-nochoice! values node killers)
  (ctrace "All of the values " ($literal values) " for "
	  ($literal (cell/good-name node)) " are no good.")
  (enqueue-contradiction/resolution!
   (list-remove-duplicates
    (map (lambda (killer)
	   (cons (repository/supplier (car killer)) (cdr killer)))
	 (list-transform-negative
	     (mapcan (lambda (killer)
		       (list-copy (cdr killer)))
		     killers)
	   (let ((repository (cell/repository node)))
	     (lambda (killer)
	       (eq? repository (car killer))))))
    eq?
    car)))