SwitchView subclass: #DanceIconView
	instanceVariableNames: 'danceView icon '
	classVariableNames: 'ClassVarName1 ClassVarName2 '
	poolDictionaries: ''
	category: 'DanceWorld'!

!DanceIconView methodsFor: 'Display'!
displayView
	"centers the icon in the icon window"

| aRect aForm |
super displayView.
aRect _ self insetDisplayBox.
icon displayOn: Display
	 at: (aRect center-20)
	 clippingBox: aRect
	 rule: Form over
	 mask: Form black.!
setIcon: anIcon
	"sets the menu icon to anIcon"

icon _ anIcon! !

Object subclass: #DanceModel
	instanceVariableNames: 'film pencil rubber face scopeBox clearScopeBox startFrame editFrame view filmStore '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'DanceWorld'!

!DanceModel methodsFor: 'View Access'!
view
	"Returns dance models view"

	^view!
view: aView

	"Set dance models view"

	view _ aView! !

!DanceModel methodsFor: 'Dance '!
dance
	" Creates a new dancer and continues to dance until
 	  the mouse is clicked whilst the last frame is displayed"

	| dancer |
	dancer _ Dancer conceive.
	dancer view: (self view).
	[Sensor anyButtonPressed not] whileTrue: [ dancer dance: film]! !

!DanceModel methodsFor: 'Define dance'!
acceptFrame

	"Append 'editFrame' to the current film"

	film addLast: editFrame!
defineFrame

	"Define the next frame to be appended to the current film"

	| selectedScope selectedPoint newPoint origin leftHand leftElbow shoulder rightElbow rightHand neck hips leftKnee leftFoot rightKnee rightFoot pointBag |

	origin _ (self hallBoundary) center.
	selectedScope _3 @ 3.
	self setEditFrame.
	view clearInside.
	self drawDancer: editFrame.
	[Sensor blueButtonPressed not and:[ (Sensor yellowButtonPressed not)
	 and: [((self hallBoundary) containsPoint: Sensor mousePoint) or: [Sensor anyButtonPressed not]]]]
	whileTrue:[ selectedPoint _ 0.
				leftHand _ origin + (editFrame at: 1).
				leftElbow _ origin + (editFrame at: 2).
				shoulder _ origin + (editFrame at: 3).
				rightElbow _ origin + (editFrame at: 4).
				rightHand _ origin + (editFrame at: 5).
				neck _ origin + (editFrame at: 6).
				hips _ origin + (editFrame at: 7).
				leftKnee _ origin + (editFrame at: 8).
				leftFoot _ origin + (editFrame at: 9).
				rightKnee _ origin + (editFrame at: 10).
				rightFoot _ origin + (editFrame at: 11).
				pointBag _ Bag new.
				Sensor redButtonPressed
		ifTrue: [ 
			newPoint _ Sensor mousePoint.
			(1 to: 11) do: [ : each | ( newPoint <= (( editFrame at: each ) + selectedScope + origin )
							and: [  newPoint >= (( editFrame at: each ) - selectedScope + origin ) ])
							ifTrue: [ selectedPoint _ each ] ] ].
	( selectedPoint = 1 )
	ifTrue: [ pointBag add: leftElbow.
		  	 editFrame at: 1 put: ((self rubberBandFrom: pointBag to: leftHand) - origin) ].

	( selectedPoint = 2 )
	ifTrue: [ pointBag add: shoulder; add: leftHand.
			editFrame at: 2 put: (( self rubberBandFrom: pointBag to: leftElbow ) - origin) ].

	( selectedPoint = 3 )
	ifTrue: [ pointBag add: leftElbow; add: rightElbow; add: hips; add: neck.
			 editFrame at: 3 put: (( self rubberBandFrom: pointBag to: shoulder ) - origin) ].

	( selectedPoint = 4 )
	ifTrue: [ pointBag add: rightHand; add: shoulder.
			 editFrame at: 4 put: (( self rubberBandFrom: pointBag to: rightElbow) - origin) ].

	( selectedPoint = 5 )
	ifTrue: [  pointBag add: rightElbow.
			  editFrame at: 5 put: (( self rubberBandFrom: pointBag to: rightHand ) - origin)].

	( selectedPoint = 6 )
	ifTrue: [ pointBag add: shoulder.
			  self displayFaceAt: (editFrame at: 6) rule: (Form erase).
			  editFrame at: 6 put: (( self rubberBandFrom: pointBag to: neck ) - origin ).
			  self displayFaceAt: (editFrame at: 6) rule: (Form over). ].

	( selectedPoint = 7 )
	ifTrue: [ pointBag add: shoulder; add: leftKnee; add: rightKnee.
			 editFrame at: 7 put: (( self rubberBandFrom: pointBag to: hips ) - origin ) ].

	( selectedPoint = 8 )
	ifTrue: [ pointBag add: hips; add: leftFoot.
			 editFrame at: 8 put: (( self rubberBandFrom: pointBag to: leftKnee ) - origin ) ].


	( selectedPoint = 9 )
	ifTrue: [ pointBag add: leftKnee.
			 editFrame at: 9 put: (( self rubberBandFrom: pointBag to: leftFoot ) - origin ) ].

	( selectedPoint = 10 )
	ifTrue: [ pointBag add: hips; add: rightFoot.
			 editFrame at: 10 put: (( self rubberBandFrom: pointBag to: rightKnee ) - origin ) ].

	( selectedPoint = 11 )
	ifTrue: [ pointBag add: rightKnee.
			 editFrame at: 11 put: (( self rubberBandFrom: pointBag to: rightFoot ) - origin ) ]].!
displayFaceAt: neck rule: aRule

	" display the face on the screen according to aRule"

	face displayOn: Display  at: (( self hallBoundary center ) + (neck - (10@20)))
		  clippingBox: self hallBoundary 
		  rule: aRule mask: (Form black).!
displayScopeBox: joint using: tool

	" Display the scope box on a joint specified by point 'joint', using 'tool' "

	tool displayOn: Display
			at: joint
			clippingBox: self hallBoundary
			rule: Form over
			mask: Form black.!
drawALine: start to: finish using: tool

	tool frame: self hallBoundary.
	tool place: start.
	tool goto: finish.!
drawDancer: frame

	" Draw the dancer in readiness for dance editing "

	| origin |

	origin _ self hallBoundary center.
	pencil up.
	pencil goto: origin + ( frame at: 1 ).
	pencil down.
	pencil goto: origin + ( frame at: 2 ).
	pencil goto: origin + ( frame at: 3 ).
	pencil goto: origin + ( frame at: 4 ).
	pencil goto: origin + ( frame at: 5 ).
	pencil up.
	pencil goto: origin + ( frame at: 6 ).
	pencil down.
	pencil goto: origin + ( frame at: 3 ).
	pencil goto: origin + ( frame at: 7 ).
	pencil goto: origin + ( frame at: 8 ).
	pencil goto: origin + ( frame at: 9 ).
	pencil up.
	pencil goto: origin + ( frame at: 7 ).
	pencil down.
	pencil goto: origin + ( frame at: 10 ).
	pencil goto: origin + ( frame at: 11 ).
	self displayFaceAt: (frame at: 6) rule: (Form over).
	1 to: 11 do: [ :each | self displayScopeBox: ( origin + ( frame at: each)) using: scopeBox ].!
hallBoundary

	" Determines the size of the dance hall"

	^view insetDisplayBox insetBy:1!
rubberBandFrom: startPoints to: initCentrePoint

	" Change the point 'initCentrePoint' with respect to the 'startPoints' "

	| centrePoint previousCentrePoint rubberPen |
	
	rubberPen _ Pen new defaultNib: 1 ; combinationRule: Form reverse ; mask: Form black.
	previousCentrePoint _ initCentrePoint.
	[Sensor redButtonPressed] whileTrue:
		[((centrePoint _ Sensor cursorPoint) = previousCentrePoint)
			ifFalse:
			[ (centrePoint = nil) 
				ifFalse:
				[ self displayScopeBox: initCentrePoint using: clearScopeBox.
				startPoints do: [ :startPoint |  self drawALine: startPoint to: previousCentrePoint using: 								rubberPen ].
				 startPoints do: [ :startPoint | self drawALine: startPoint to: centrePoint using: rubberPen ].	
		 		 previousCentrePoint  _ centrePoint] ] ].
	startPoints do: [ :startPoint | self drawALine: startPoint to: previousCentrePoint using: pencil;
							    displayScopeBox: startPoint using: scopeBox].
	self displayScopeBox: previousCentrePoint using: scopeBox.
	
	^previousCentrePoint!
setEditFrame

	" Set the edit frame to be the last frame on the current film "
	
	editFrame _ (film last) copyFrom: 1 to: 11..! !

!DanceModel methodsFor: 'Initialisation'!
addDefaultFilm: anArray called: aName
	" transforms the supplied array into a film, and  stores it in the film bank "

	| aFrame aFilm aPoint frames |

	aFilm_ OrderedCollection new: 20.
	frames _ (anArray size) / 22.
	1 to: frames do: [ :eachFrame |
		aFrame _ Array new: 11.
		1 to: 11 do: [ :eachPoint | 
			aPoint _ Point 	x:(anArray at: ((eachFrame-1) * 22 + (eachPoint*2) - 1 )) 
							y:(anArray at: ((eachFrame-1) * 22 + (eachPoint*2))).
			aFrame at: eachPoint put: aPoint ].
		aFilm add: aFrame].
	aFilm addFirst: aName.
	filmStore add: aFilm.!
initialiseFace

	" Initialise the dancers face "
	
	face _ Form extent: 21@ 21
			fromArray: #( 0 0 508 0 4095 32768 8191 49152 16379 57344 32705 61440 32256 61440 63488 63488 61440 30720 59143 14336 51882 38912 34599 2048 32848 2048 32848 2048 32880 2048 50177 6144 25350 12288 12796 24576 6144 49152 3587 32768 2047 0 ) offset: 0 @ 0.!
initialiseFilm

	" Initialise the originalfilm "

	film _ OrderedCollection new: 20.
	film add: startFrame!
initialiseFilmStore

	" stores some default frames"

	filmStore _ OrderedCollection new: 20.
	self addDefaultFilm: #(-30 20  -20 0  0 0  20 0  30 20  0 -10  0 30  -20 50  -25 70  20 50  25 70)
			called:'Initial Stance'.
 	self addDefaultFilm: 
	#(-30 20  -20 0  0 0  20 0  30 20  0 -10  0 30  -20 50  -25 70  20 50  25 70 
	   -30 20  -20 0  0 0  20 0  30 20  0 -10 -19 34 -20 50  -25 70  20 50  25 70
	   -30 20  -20 0  0 0  20 0  30 20  0 -10  24 38  -20 50  -25 70  20 50  25 70 
	   -30 20  -20 0  0 0  20 0  30 20  0 -10 -44 38  -20 50  -25 70  20 50  25 70 
 	   -30 20  -20 0  0 0  20 0  39 -15 0 -10  75 38  -20 50  -25 70  20 50  25 70 
	   -53 -11 -20 0  0 0  20 0  39 -15 0 -10 -112 32 -20 50  -25 70  20 50  25 70 ) 
	called: 'Epileptic Belly Dancer'.
	self addDefaultFilm:
  	#(-30 20 -20 0 0 0 20 0 30 20 0 -10 0 30 -20 50 -25 70 20 50 25 70  -32 10 -20 0 0 7 20 0 37 12 0 -10 	-1 38 -20 50 -25 70 20 50 25 70  -34 -3 -20 0 0 11 20 0 44 1 0 -4 -1 42 -20 50 -25 70 20 50 25 70  -38 	-11 -20 0 0 11 20 0 39 -17 0 -4 -1 52 -20 50 -27 66 20 50 25 70  -38 -11 -20 0 0 11 20 0 39 -17 0 -4 -1 	36 -20 50 -28 56 20 50 32 63  -41 -4 -20 0 0 11 20 0 42 -1 0 -4 -1 36 -20 50 -13 70 20 50 25 67  -18 17 	-20 0 0 11 20 0 15 -14 0 -4 1 27 -7 51 -13 70 30 38 25 67  -18 17 -20 0 0 11 34 8 38 -11 0 -4 1 27 -27 	43 -13 70 30 38 25 67  -35 17 -20 0 -1 7 34 8 50 4 0 -4 1 35 -27 43 -13 70 30 38 25 67 ) 
	called: 'Warwick''s wobble'.
	self addDefaultFilm:
	#(-30 20  -20 0  0 0  20 0  30 20  0 -10  0 30  -20 50  -25 70  20 50  25 70 
	   -30 20  -20 0  0 0  20 0  37 17  0 -10  0 30  -20 50  -25 70  20 50  25 70 
	   -30 20  -20 0  0 0 20 0 43 9 0 -10 0 30 -20 50 -25 70 20 50 25 70 
	   -30 20  -20 0 0 0 20 0 45 1 0 -10 0 30 -20 50 -25 70 20 50 25 70 
	   -30 20  -20 0 0 0 20 0 37 -12 0 -10 0 30 -20 50 -25 70 20 50 25 70
	   -20 22  -13 8 0 0 14 0 25 -13 0 -10 0 30 -12 50 -11 69 10 47 17 68
	    -8 13  -6 7 0 0 9 -2 10 -13 0 -10 0 30 1 48 4 66 6 47 9 62 
	    4 13   -6 7 0 0 9 -2 -6 -7 0 -10 0 30 13 45 14 63 -4 47 1 62
	   33 13  13 5 0 0 -16 -1 -27 -7 0 -10 0 30 16 44 17 63 -14 44 -15 61
	   22 -7  11 -8 -2 -11 -16 -16 -27 -23 -2 -23 -2 13 16 29 21 49 -20 29 -22 49 
 	   34 -13 14 -15 -1 -17 -20 -23 -39 -24 -2 -29 -2  13 17 33 24 61 -11 32 -12 60
 	   16 -36 13 -20 -2 -12 -20 -23 -25 -39 -2 -29 1 13 17 33 24 61 -11 32 -12 60 
	   7 -38 13 -20 -2 -12 -20 -23 -15 -39 -2 -29 1 13 17 61 -11 32 -12 60 )
	called: 'Jaggar Jive'.
	self addDefaultFilm: 
 	#( -30 20 -20 0 0 0 20 0 30 20 0 -10 0 30 -20 50 -25 70 20 50 25 70 
 	-10 22 -23 7 0 0 25 6 8 24 0 -10 0 30 -20 50 -25 70 20 50 25 70  
	18 24 -21 12 0 0 25 12 -13 24 0 -10 0 30 -20 50 -25 70 20 50 25 70    
	-14 23 -29 4 0 0 32 4 15 21 0 -10 0 30 -20 50 -25 70 20 50 25 70   
	-11 24 -28 14 0 0 25 2 29 20 0 -10 0 30 -17 52 -25 70 23 49 25 70   
	-11 24 -28 14 0 0 21 2 40 12 0 -10 4 30 -16 52 -25 70 31 48 25 70  
 	-7 24 -20 18 0 0 22 -2 49 -9 0 -10 4 30 -13 49 -25 70 35 46 28 70  
 	-28 36 -25 19 0 0 23 -6 35 -31 0 -10 -12 32 -9 52 -25 70 44 47 39 67  
 	-27 25 -26 10 0 0 20 -1 38 -17 0 -10 -12 32 -16 51 -25 70 29 44 39 67  
 	-36 19 -32 4 0 0 20 -1 44 -4 0 -10 -6 27 -25 44 -28 70 22 40 31 56   
	-36 19 -30 0 0 0 23 -2 44 8 0 -10 -6 27 -25 44 -32 69 19 42 25 65 )  
	called:'Streeets Strut'.!
initialiseScopeBox

	" Initialise the a shape to outline the body joint positions "

	scopeBox _ Form extent: 5@5 fromArray: #( 63488 34816 34816 34816 63488 ) offset: -2@-2.

	clearScopeBox _ Form extent: 5@5 fromArray: #(0 0 0 0 0 )  offset: -2@-2!
initialiseStartFrame

	" Dancers starting position"

	startFrame _ Array new: 11.
	startFrame at: 1 put: -30 @ 20.
	startFrame at: 2 put: -20 @ 0.
	startFrame at: 3 put: 0 @ 0.
	startFrame at: 4 put: 20 @ 0.
	startFrame at: 5 put: 30 @ 20.
	startFrame at: 6 put: 0 @ -10.
	startFrame at: 7 put: 0 @ 30.
	startFrame at: 8 put: -20 @ 50.
	startFrame at: 9 put: -25 @ 70.
	startFrame at: 10 put: 20 @ 50.
	startFrame at: 11 put: 25 @ 70.!
initialiseTools

	" Initialise the tools used to draw the dancer "

	pencil _ Pen new black; defaultNib: 1.

	rubber _ Pen new white; combinationRule: Form over ; defaultNib: 1.! !

!DanceModel methodsFor: 'Film Access'!
append: first and: second

	" Returns a new string, second appended to first "
	
	|temp|
	temp _ first.
	temp _ temp forceTo: ((temp size) + 1) paddingWith: Character space.
	second do: [:aChar | temp at: (temp size) put: aChar.
				temp _ temp forceTo: ((temp size) + 1) paddingWith: Character space].
	temp at: (temp size) put: Character cr.
	^temp.
!
appendstring: first andstring: second

	" Returns a new string, second appended to first with a newline at the end "
	
	|temp newline|
	newline _ String with: Character cr.
	temp _ first, second.
	temp _ temp,newline.
	^temp!
chooseFilm

	" Select the next film, from a pop-up menu, to dance or to be edited "

	| aFilm menuString filmMenu answer |
	
	menuString _ String new.
	filmStore do: [:aFilm | menuString _ self appendstring: menuString andstring: (aFilm first)].
	menuString at: menuString size put: Character space.
	filmMenu _ PopUpMenu labels: menuString.
	answer _ filmMenu startUp: #redButton withHeading: 'Please choose a dance'.
	(answer = 0) ifFalse: [film _ filmStore at: answer.]!
newFilm

	" Prompts for the name of the next dance to be defined "

	| answer aFilm |

	answer _ FillInTheBlank request: 'Please enter name of new Film'.
	aFilm _ OrderedCollection new:20.
	aFilm add:answer; add: self startFrame.
	film _ aFilm.
	filmStore add: aFilm.! !

!DanceModel methodsFor: 'Access'!
startFrame
	" Returns a copy of the start frame "

	| aStartFrame |

	aStartFrame _ startFrame copyFrom: 1 to: 11.

	^aStartFrame! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DanceModel class
	instanceVariableNames: 'hall '!

!DanceModel class methodsFor: 'creation'!
create
	" Creates a new dance hall "

	| newHall |
	newHall _self new.
	hall _ newHall.
	newHall	 initialiseFace;
			initialiseStartFrame;
			initialiseFilmStore;
			initialiseScopeBox;
			initialiseTools.
	
	^newHall! !

Object subclass: #Dancer
	instanceVariableNames: 'activeView face pen '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'DanceWorld'!

!Dancer methodsFor: 'initialise'! !

!Dancer methodsFor: 'dancing'!
white! !

!Dancer methodsFor: 'access'! !

!Dancer methodsFor: 'Initialise'!
initialise

	self initialiseFace.
	self initialisePen.!
initialiseFace

	face _ Form extent: 21@ 21
			fromArray: #( 0 0 508 0 4095 32768 8191 49152 16379 57344 32705 61440 32256 61440 63488 63488 61440 30720 59143 14336 51882 38912 34599 2048 32848 2048 32848 2048 32880 2048 50177 6144 25350 12288 12796 24576 6144 49152 3587 32768 2047 0 ) offset: 0 @ 0.!
initialisePen

	pen _ Form extent: 5 @ 5 fromArray:  #(28672 63488 63488 63488 28672 ) offset: -2 @ 0.! !

!Dancer methodsFor: 'Dancing'!
dance: aFilm
	"the dancer will dance the dance described in film"

| aFrame filmFrames |
filmFrames _ aFilm copyFrom: 2 to: (aFilm size).
filmFrames do: [:aFrame | self displayFrame: aFrame]!
displayFrame: aFrame
	" display a frame "
	| leftHand leftElbow shoulder rightElbow rightHand neck hips leftKnee leftFoot rightKnee rightFoot form viewRect origin |


	viewRect _ activeView insetDisplayBox.
	origin _ (viewRect center) - (viewRect origin).
	leftHand _ origin + (aFrame at: 1).
	leftElbow _ origin + (aFrame at: 2).
	shoulder _ origin + (aFrame at: 3).
	rightElbow _ origin + (aFrame at: 4).
	rightHand _ origin + (aFrame at: 5).
	neck _ origin + (aFrame at: 6) .
	hips _ origin + (aFrame at: 7).
	leftKnee _ origin + (aFrame at: 8).
	leftFoot _ origin + (aFrame at: 9).
	rightKnee _ origin + (aFrame at: 10).
	rightFoot _ origin + (aFrame at: 11).
	form _ Form new extent: (viewRect extent).
	self drawOn: form from: leftHand to: leftElbow. 
	self drawOn: form from: leftElbow to: shoulder.
	self drawOn: form from: rightHand to: rightElbow.
	self drawOn: form from: rightElbow to: shoulder.
	self drawOn: form from: shoulder to: neck.
	self drawOn: form from: shoulder to: hips.	
	self drawOn: form from: hips to: leftKnee.
	self drawOn: form from: leftKnee to: leftFoot.
	self drawOn: form from: hips to: rightKnee.
	self drawOn: form from: rightKnee to: rightFoot.
	form copyBits: (face boundingBox) from: face at: (neck - (10@20))
		  clippingBox: (0@0 corner: (viewRect extent)) 
		  rule: (Form over) mask: (Form black).
	form displayOn: Display
		  at: (viewRect origin)
		  clippingBox: viewRect.!
drawOn: aForm from: start to: end

	aForm drawLine: pen from: start to: end 
		clippingBox: (0@0 corner: (activeView insetDisplayBox extent))
		rule: (Form paint) mask: (Form black).! !

!Dancer methodsFor: 'Access'!
view
	" returns the active View"

	^ activeView!
view: aView
	" sets the active View"
	activeView _ aView.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Dancer class
	instanceVariableNames: ''!

!Dancer class methodsFor: 'creation'!
conceive
	" gives birth to a new dancer "

	| torville |
	
	torville _ self new.
	torville initialise.
	^ torville! !

View subclass: #DanceView
	instanceVariableNames: 'defineButtonAction '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'DanceWorld'!

!DanceView methodsFor: 'Actions'!
acceptFrame

model acceptFrame.
defineButtonAction indicatorOnDuring: [model defineFrame]!
chooseFilm
	" choose a stored film "

	model chooseFilm.!
dance

model dance!
defineFrame

model defineFrame!
newFilm

	model newFilm!
setDefineButton: aButton

	" Keep track of the define button so that can select it within the accept button"

defineButtonAction _ aButton! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DanceView class
	instanceVariableNames: ''!

!DanceView class methodsFor: 'creation'!
buildDanceView
	"open a view for dancing, with buttons containing icons "

	| topView dancingView danceModel acceptButton chooseFilmButton danceButton defFrameButton 
	newFilmButton acceptSwitch chooseFilmSwitch danceSwitch defFrameSwitch newFilmSwitch |
	
	topView _ View new.
	dancingView _ self new.
	danceModel _ DanceModel create.
	danceModel view: dancingView.
	dancingView borderWidth:0.
	dancingView insideColor: Form white; borderWidth: 1; model: danceModel.
	dancingView controller: MouseMenuController new initialize.
	topView addSubView: dancingView viewport: (0.2@0 extent: 0.8@1).

	danceButton _ Button newOff onAction: [dancingView dance].
	danceSwitch _ DanceIconView new model: danceButton.
	danceSwitch setIcon: DanceView danceIcon.
	danceSwitch controller: IndicatorOnSwitchController new; 
	insideColor: Form white; borderWidth: 1.
	topView addSubView: danceSwitch viewport:(0@0 extent: 0.2@0.2).

	chooseFilmButton _ Button newOff onAction: [dancingView chooseFilm].
	chooseFilmSwitch _ DanceIconView new model: chooseFilmButton.
	chooseFilmSwitch setIcon: DanceView chooseFilmIcon.
	chooseFilmSwitch controller: IndicatorOnSwitchController new; 
	insideColor: Form white; borderWidth: 1. 
	topView addSubView: chooseFilmSwitch viewport:(0@0.2 extent: 0.2@0.2).

	newFilmButton _ Button newOff onAction: [dancingView newFilm].
	newFilmSwitch _ DanceIconView new model: newFilmButton.
	newFilmSwitch setIcon: DanceView newFilmIcon.
	newFilmSwitch controller: IndicatorOnSwitchController new; 
	insideColor: Form white; borderWidth: 1.
	topView addSubView: newFilmSwitch viewport:(0@0.4 extent: 0.2@0.2).

	defFrameButton _ Button newOff onAction: [dancingView defineFrame].
	defFrameSwitch _ DanceIconView new model: defFrameButton.
	defFrameSwitch setIcon: DanceView defFrameIcon.
	defFrameSwitch controller: IndicatorOnSwitchController new; 
	insideColor: Form white; borderWidth: 1.
	dancingView setDefineButton: defFrameSwitch.
	topView addSubView: defFrameSwitch viewport:(0@0.6 extent: 0.2@0.2).

	acceptButton _ Button newOff onAction: [dancingView acceptFrame].
	acceptSwitch _ DanceIconView new model: acceptButton.
	acceptSwitch setIcon: DanceView acceptIcon.
	acceptSwitch controller: IndicatorOnSwitchController new; 
	insideColor: Form white; borderWidth: 1.
	topView addSubView: acceptSwitch viewport:(0@0.8 extent: 0.2@0.2).

	^topView!
open
	" Instantiates a new Dance View. "

|topView subViews|

topView _ StandardSystemView new.
topView model: nil; label: 'Dance World'; minimumSize: 200@200;
insideColor: Form white.
subViews _ self buildDanceView.
topView addSubView: subViews viewport: (0@0 extent: 1@1).
topView controller open.! !

!DanceView class methodsFor: 'create icons'!
acceptIcon
	" The definition of the acceptance icon "

^Form extent: 40@40
fromArray: #(0 0 0 0 0 0 0 0 0 65535 65535 65280 65535 65535 65280 65535 65535 65280 3072 0 24576 3072 0 24576 3072 0 24576 3072 0 24576 3078 480 24576 3087 1008 24576 3087 2040 24576 3103 34808 24576 3103 34808 24576 3135 51192 24576 3135 50160 24576 3135 50160 24576 3135 50160 24576 3135 50160 24576 3135 50160 24576 3135 51192 24576 3103 34808 24576 3103 34808 24576 3103 34808 24576 3103 34808 24576 3103 34808 24576 3135 51192 24576 3135 50160 24576 3135 50160 24576 3135 49632 24576 3103 33248 24576 3087 192 24576 3072 0 24576 3072 0 24576 65535 65535 65280 65535 65535 65280 65535 65535 65280 0 0 0 0 0 0 )
offset: 0@0!
chooseFilmIcon

^Form extent: 40@40
fromArray: # (7 65472 0 127 65532 0 65020 127 0 34800 31 32768 34753 33671 49152 36743 33731 57344 57103 33777 61440 24095 33784 61440 23615 33784 28672 56320 14336 28672 39936 14336 28672 39999 33784 28672 40511 33784 61440 7967 33761 61440 3975 33731 57344 1987 33543 49152 1008 31 57344 2044 127 28672 3711 65534 28672 7391 65527 6144 6595 65408 7168 12480 0 3072 12336 15360 3072 12300 15360 3072 12288 15487 52224 12288 1 52224 6144 33280 56320 6161 33024 7168 7199 128 29696 3598 192 25600 1804 224 58368 480 455 50176 124 31 1024 4063 65528 1024 14563 65472 1024 12848 0 2048 26672 0 2048 24766 7168 4096 12913 5120 4096 8160 62448 4096 ) offset: 0@0!
danceIcon

^Form extent: 40@40
fromArray: #(7 65472 0 15 65504 0 31 65520 0 31 33272 0 60 120 0 60 56 0 56 24 0 57 59272 0 50 9288 0 35 59336 0 32 2056 0 16 6152 0 8 4104 0 4 6152 0 4 32912 0 2 32544 0 2 64 0 7 32960 0 13 32636 0 121 67 0 225 4224 49152 432 33928 57344 532 41121 36864 1040 52353 2048 2064 16659 3072 4112 26914 1024 4107 8738 512 8205 8706 256 16388 5196 256 32772 38152 0 4 7176 0 4 8744 0 4 41480 49152 386 57864 57344 642 7176 36864 1154 216 34816 3202 16688 33792 2177 4400 33280 2177 3088 49152 4225 4112 16384 )
offset: 0@0!
defFrameIcon

^Form extent: 40@40
fromArray: #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 7 896 0 31 34784 0 63 34800 0 127 53240 0 127 53240 0 255 53244 0 255 53244 0 255 53244 0 255 53244 0 255 53244 0 255 53244 0 127 34808 0 127 34808 0 127 34808 0 63 34800 0 63 34800 0 31 34784 0 31 34784 0 31 34784 0 31 34784 0 63 34800 0 63 53232 0 63 53232 0 63 53232 0 63 53232 0 31 34784 0 15 960 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 )
offset: 0@0!
newFilmIcon

^Form extent: 40@40
fromArray: #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 64512 0 511 65280 0 768 25024 0 1536 49376 0 3585 35952 0 3073 35960 0 3585 35960 0 1536 49388 0 1023 57804 0 511 65486 0 0 32718 0 0 15468 0 0 14396 0 0 28696 0 0 64568 0 1 50800 0 3 33760 0 7 448 0 15 50048 0 28 26368 0 56 15872 0 112 7168 0 252 14336 0 454 61440 0 1023 57344 0 0 0 0 0 0 0 0 0 0)
offset: 0@0! !