Object subclass: #Monster
	instanceVariableNames: 'colour '
	classVariableNames: 'Population '
	poolDictionaries: ''
	category: 'SesameStreet'!


!Monster methodsFor: 'initialization'!

initializeWithColour: aString 
	"initialize ivars of monster"

	colour _ aString.
	Monster recordMonster! !

!Monster methodsFor: 'queries'!

colour
	"show the beast's colour"

	^colour! !

!Monster methodsFor: 'actions'!

blush
	"switch colour to pink"

	self colour: 'pink'!

paint: aString 
	"assign a new value to colour"

	colour _ aString! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Monster class
	instanceVariableNames: ''!


!Monster class methodsFor: 'actions'!

recordMonster
	"count the number of monsters"

	Population isNil
		ifTrue: [Population _ 0]
		ifFalse: [Population _ Population + 1]! !

!Monster class methodsFor: 'query'!

howManyMonstersAreThere
	"return value of class variable Population"

	^Population! !

!Monster class methodsFor: 'creation'!

makeWithColour: aString 
	"makes and returns a new monster instance"

	| herman |
	herman _ self new.
	^herman! !


Monster subclass: #CookieMonster
	instanceVariableNames: 'tummy greed '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'SesameStreet'!


!CookieMonster methodsFor: 'initialization'!

initializeWithColour: aString andGreed: aNumber 
	"initialize ivars of cookie monster"

	greed _ aNumber.
	tummy _ Bag new.
	super initializeWithColour: aString! !

!CookieMonster methodsFor: 'queries'!

greed
	"show the cookie monster's greed"

	^greed!

isFull
	"is the cookie monster still hungry ?"

	^(tummy size >= greed)!

tummy
	"show the contents of the cookie monster's tummy"

	^tummy! !

!CookieMonster methodsFor: 'actions'!

cryCookie
	"keep asking for a cookie and return the item received"

	| itemName |
	itemName _ FillInTheBlank request: 'Give me cookie !!!!!! (please)'.
	^itemName!

eat: aString 
	"stuff item into tummy"

	tummy add: aString!

wakeUp
	"describes the life cycle of a generic cookie monster"

	| item |
	[self isFull]
		whileFalse: 
			[item _ self cryCookie.
			item = #cookie
				ifTrue: 
					[Transcript show: 'Thank you ... munch munch'; cr.
					self eat: item]
				ifFalse: [Transcript show: 'No want '; show: item asString; cr]].
	Transcript show: '... burp'; cr.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

CookieMonster class
	instanceVariableNames: ''!


!CookieMonster class methodsFor: 'creation'!

makeWithColour: aString andGreed: aNumber 
	"make and return a cookie monster instance"

	| clara |
	clara _ self new.
	clara initializeWithColour: aString andGreed: aNumber.
	^clara! !
