; test of Steepest Ascent Search method
;
; simple test involving initial state (1 1 1) and each state can generate
; three new states with each possible value incremented.
; E.g. (1 1 1) can generate new states (2 1 1), (1 2 1) and (1 1 2)
;

! (define inc1
    (lambda (aState)
      (cons (+ 1 (car aState))
            (cdr aState))))
  
! (define inc2
    (lambda (aState)
      (cons (car aState)
            (cons (+ 1 (cadr aState))
                  (cddr aState)))))
  
! (define inc3
    (lambda (aState)
      (cons (car aState)
            (cons (cadr aState)
                  (cons (+ 1 (caddr aState))
                        (cdddr aState))))))


; Look for (3 2 1) and use evaluation function that counts the number
; of pairs in decreasing order and subtracts number in reverse order


! (define decreasing
    (lambda (aState)
      (define inorder
        (lambda (x y)
          (cond ((= x y) 0)
                ((> x y) +1)
                (else -1))))
      (+ (inorder (car aState) (cadr aState))
         (inorder (cadr aState) (caddr aState)))))
  
! (define SteepestProblem
    ; Goal state is state (3 2 1)
    (MakeSearchProblem '(1 1 1)
                       (lambda (aState) (equal? aState '(3 2 1)))
                       decreasing
                       (list inc1 inc2 inc3)))
  
; this should succeed
= (SteepestSearch SteepestProblem)
  (4 9 (#(ok 2 (3 2 1))
        #(ok 1 (2 2 1))
        #(ok 1 (2 1 1))
        #(ok 0 (1 1 1))))

! (define increasing
    (lambda (aState)
      (define inorder
        (lambda (x y)
          (cond ((= x y) 0)
                ((< x y) +1)
                (else -1))))
      (+ (inorder (car aState) (cadr aState))
         (inorder (cadr aState) (caddr aState)))))
  
! (define SteepestProblem
    ; Goal state is state (1 2 3)
    (MakeSearchProblem '(1 1 1)
                       (lambda (aState) (equal? aState '(1 2 3)))
                       increasing
                       (list inc1 inc2 inc3)))
  
; this should succeed
= (SteepestSearch SteepestProblem)
  (4 9 (#(ok 2 (1 2 3))
        #(ok 1 (1 1 3))
        #(ok 1 (1 1 2))
        #(ok 0 (1 1 1))))
  
