; Simple Rogerian therapist simulation
;

(define Shrink-Conversation
  (lambda ()
    
    ; the Shrink KB and globals
    (let ((Shrink-KB #f)
          (allDone #f))
      
      ; store all patterns for conversation as a pair of the pattern
      ; to match and a procedure to call upon successful match
      
      (define makeFact
        (lambda (aPattern aProcedure) (cons aPattern aProcedure)))
      
      (define selectPattern car)
      (define selectProc cdr)
      
      ; functions to test for word properties
      
      (define verb?
        (lambda (anAL)
          ; is the variable verb a verb?
          (member (GetAssociationValue 'verb anAL)
                  '(go have be try eat take help make get jump
                    write type fill put turn compute
                    think drink blink crash crunch add))))
      
      (define whyWord?
        (lambda (anAL)
          ; is the variable why a why type word?
          (member (GetAssociationValue 'why anAL)
                  '(why where when what))))
      
      (define doWord?
        (lambda (anAL)
          ; is the variable do a do type word?
          (member (GetAssociationValue 'do anAL)
                  '(do can should would))))
      
      (define iWord?
        (lambda (anAL)
          ; is the variable i an I type word?
          (member (GetAssociationValue 'i anAL) '(i me))))
      
      (define changePerson
        (lambda (aList)
          ; change from 1st to 2nd person and vice versa
          (define 1<->2Person
            (lambda (word)
              (cond ((eq? word 'i)     'you)
                    ((eq? word 'me)    'you)
                    ((eq? word 'you)   'me)
                    ((eq? word 'my)    'your)
                    ((eq? word 'your)  'my)
                    ((eq? word 'yours) 'mine)
                    ((eq? word 'mine)  'yours)
                    ((eq? word 'am)    'are)
                    (else word))))
          (map 1<->2Person aList)))
      
      (define questionNo 0)
      (define questionList '(when why where))
      (define question
        (lambda ()
          (set! questionNo (+ 1 questionNo))
          (if (= questionNo (length questionList))
              (set! questionNo 0)
              #f)
          (list-ref questionList questionNo)))
      
      (define replyNo 0)
      (define replyList '("Please go on"
                          "Tell me more"
                          "I see"
                          "What does that indicate?"
                          "But why be concerned about that?"
                          "Just tell me how you feel"))
      (define generalReply
        (lambda ()
          (set! replyNo (+ 1 replyNo))
          (if (= replyNo (length replyList))
              (set! replyNo 0)
              #f)
          (list-ref replyList replyNo)))
      
      (define reply
        (lambda aList
          ; display list without outer brackets or sublists
          
          (define replyAux
            (lambda (aList)
              (do ((rest aList (cdr rest)))
                  ((null? rest))
                  (if (pair? (car rest))
                      (replyAux (car rest))
                      (display (car rest)))
                  (display " "))))
          
          (replyAux aList)))
      
      ; build the Knowledge Base
      
      (define initKB
        (lambda ()
          (set!
           Shrink-KB
           (MakeKB
            (makeFact (PATTERN 'Bye)
                      (lambda (al)
                        (set! allDone #t)
                        (reply "Come back soon. Goodbye")
                        (newline)))
            (makeFact (PATTERN 'I 'am ?+)
                      (lambda (al)
                        (reply "Please tell me" (question) "you are")))
            (makeFact (PATTERN 'I 'have (?+ 'x))
                      (lambda (al)
                        (reply "How long have you had"
                               (changePerson (GetAssociationValue 'x al)))))
            (makeFact (PATTERN 'I 'feel ?+)
                      (lambda (al) (reply "I sometimes feel the same way")))
            (makeFact (PATTERN 'Because ?+)
                      (lambda (al) (reply "Is that really the reason?")))
            (makeFact (PATTERN 'Yes ?+)
                      (lambda (al) (reply "How can you be so sure?")))
            (makeFact (PATTERN )
                      (lambda (al) (reply "Please say something")))
            (makeFact (PATTERN 'You 'are (?+ 'something))
                      (lambda (al)
                        (reply "O yeah. I am"
                               (changePerson
                                (GetAssociationValue 'something al)))))
            (makeFact (PATTERN (? 'verb verb?) (?+ 'rest))
                      (lambda (al)
                        (reply "So you want me to go and"
                               (GetAssociationValue 'verb al)
                               (changePerson (GetAssociationValue 'rest al)))))
            (makeFact (PATTERN (? 'why whyWord?) (?+ 'rest))
                      (lambda (al)
                        (reply "You tell me"
                               (GetAssociationValue 'why al))))
            (makeFact (PATTERN (? 'do doWord?) 'you (?+ 'rest))
                      (lambda (al)
                        (reply "Perhaps I"
                               (GetAssociationValue 'do al)
                               (changePerson (GetAssociationValue 'rest al)))))
            (makeFact (PATTERN 'Do 'you 'think ?+)
                      (lambda (al)
                        (reply "I think you should answer that yourself")))
            (makeFact (PATTERN ?+ 'dream ?+)
                      (lambda (al)
                        (reply "For dream analysis see Freud")))
            (makeFact (PATTERN ?+ 'love ?+)
                      (lambda (al) (reply "All is fair in love and war")))
            (makeFact (PATTERN ?+ 'no ?+)
                      (lambda (al) (reply "Don't be so negative")))
            (makeFact (PATTERN ?+ 'maybe ?+)
                      (lambda (al) (reply "Be more decisive")))
            (makeFact (PATTERN (? 'i iWord?) (?+ 'rest))
                      (lambda (al)
                        (reply "You"
                               (changePerson (GetAssociationValue 'rest al)))))
            (makeFact (PATTERN ?+)
                      (lambda (al)
                        (reply (generalReply))))))))
      
      
      (define readSentence
        (lambda ()
          (let ((sentence #f))
            (newline)
            (display "...> ")
            (set! sentence (read))
            (newline)
            (if (not (pair? sentence))
                (begin (display "Please give your replies as a list")
                       (readSentence))
                sentence))))
      
      
      (initKB)
      (set! allDone #f)
      (display "Welcome to my sofa")
      (do ((sentence #f)
           (element #f))
          (allDone #f)
          (set! sentence (readSentence))
          (set! element
                (RetrieveByString Shrink-KB
				  sentence
				  selectPattern))
          ((selectProc (GetFact element))
	      (GetAList element))))))

(begin
 (display "Type (Shrink-Conversation) to talk to the shrink")
 (newline))