; Natural Language interface for questions about the
; properties of animals

(define ConstructQuery
  (lambda (aRegisterBank)
    ; given final register values construct the query
    (let ((q (GetRegister aRegisterBank 'Q))
          (x #f)
          (y #f)
          (number #f))
      (cond ((eq? q 'What)
             (list 'what (GetRegister aRegisterBank 'X)))
            ((eq? q 'Is)
             (list 'is (GetRegister aRegisterBank 'X)
                       (GetRegister aRegisterBank 'Y)))
            ((eq? q 'have)
             (list 'number (GetRegister aRegisterBank 'X)
                           (GetRegister aRegisterBank 'Y)
                           (GetRegister aRegisterBank 'N)))
            (else (Fatal-Error "bad q"))))))

(define article (MakeCategory 'a 'an 'the))
(define animal  (MakeCategory 'dog 'cow 'snake 'lizard 'shark 'carp))
(define dog     (MakeCategory 'hyena 'spaniel))
(define class   (MakeCategory 'mammal 'reptile 'fish 'animal))

(define NP
  (MakeATN
   (STATE 'N1 (CAT article #t (TO 'N2)))
   (STATE 'N2 (CAT animal  #t (SETR 'animal **)
                              (TO 'N3))
              (CAT dog     #t (SETR 'animal **)
                              (TO 'N3))
              (CAT class   #t (SETR 'animal **)
                              (TO 'N3)))
   (STATE 'N3 (POP (GETR 'animal) #t))))
  
(define numpart (MakeCategory 'eyes 'legs 'arms 'ears 'hairs))
(define onepart (MakeCategory 'head 'mouth 'nose))
(define number  (MakeCategory 'two 'three 'four))

(define PROP
  (MakeATN
   (STATE 'P1 (CAT (MakeCategory 'have) #t (SETR 'Q **)
                                           (TO 'P2)))
   (STATE 'P2 (CAT numpart #t (SETR 'Y **)
                              (SETR 'N (lambda (x) 'any))
                              (TO 'P3))
              (CAT article #t (SETR 'N (lambda (x) 'one))
                              (TO 'P4))
              (CAT number  #t (SETR 'N **)
                              (TO 'P6)))
   (STATE 'P3 (POP ** #t))
   (STATE 'P4 (CAT onepart #t (SETR 'Y **)
                              (TO 'P5)))
   (STATE 'P5 (POP ** #t))
   (STATE 'P6 (CAT numpart #t (SETR 'Y **)
                              (TO 'P3)))))

(define What
  (MakeATN
   (STATE 'W1 (CAT (MakeCategory 'What) #t (SETR 'Q **)
                                           (TO 'W2)))
   (STATE 'W2 (CAT (MakeCategory 'is)   #t (TO 'W3)))
   (STATE 'W3 (PUSH NP     #t (SETR 'X **)
                              (TO 'W4)))
   (STATE 'W4 (POP (GETR **) #t))))

(define Is
  (MakeATN
   (STATE 'I1 (CAT (MakeCategory 'Is) #t (SETR 'Q **)
                                         (TO 'I2)))
   (STATE 'I2 (PUSH NP   #t (SETR 'X **)
                            (TO 'I3)))
   (STATE 'I3 (PUSH NP   #t (SETR 'Y **)
                            (TO 'I4)))
   (STATE 'I4 (POP (GETR **) #t))))

(define Does
  (MakeATN
   (STATE 'D1 (CAT (MakeCategory 'Does) #t (TO 'D2)))
   (STATE 'D2 (PUSH NP   #t (SETR 'X **)
                            (TO 'D3)))
   (STATE 'D3 (PUSH PROP #t (TO 'D4)))
   (STATE 'D4 (POP (GETR **) #t))))

(define Enquire
  (MakeATN
   (STATE 'E1 (PUSH What #t (TO 'E2))
              (PUSH Is   #t (TO 'E2))
              (PUSH Does #t (TO 'E2)))
   (STATE 'E2 (POP ConstructQuery #t))))

(define FormEnquiry
  (lambda (aSentence)
    ; parse sentence and return an appropriate enquiry
    (let ((result (Parse Enquire aSentence #f)))
      (if (not result)
          #f
          (GetRegister result '**)))))
