
; ==================== IMPLEMENTATIONS - level ====================

(defFlavour  System  (Ako Vanilla) 
  (ivars name inputs states outputs subsystems behaviour)
  setivars getivars testivars)

(define (makeSystem aName someInputs someStates someOutputs 
                    someSubsystems someStateEqns someOutputEqns)
   (define sys  (System 'new))     
   (define bEqns (BehaviourEqns 'new))  
   (for-each (lambda (x)                
               (bEqns 'addStateEqn! x))
              someStateEqns)
   (for-each (lambda (x)                
               (bEqns 'addOutputEqn! x))
              someOutputEqns)      
   (sys 'name!       aName) 
   (sys 'inputs!     someInputs) 
   (sys 'states!     someStates) 
   (sys 'outputs!    someOutputs) 
   (sys 'subsystems! someSubsystems) 
   (sys 'behaviour!  bEqns)
  ; return the new system instance 
  sys)

(defMethod (addInputs! System) (anInputList)
; WARNING: Does not check for duplicates !
 (Set! inputs (APPEND (self 'inputs) anInputList)) )

(defMethod (clearInputs! System) () (Set! inputs nil))

(defMethod (addStates! System) (aStateList)
; WARNING: Does not check for duplicates !
 (Set! states (APPEND (self 'states) aStateList)) )

(defMethod (clearStates! System) () (Set! states nil))

(defMethod (addOutputs! System) (anOutputList)
; WARNING: Does not check for duplicates !
 (Set! outputs (APPEND (self 'outputs) anOutputList)) )

(defMethod (clearOutputs! System) () (Set! outputs nil))

(defMethod (addSubsystems! System) (aSubsystemList)
; WARNING: Does not check for duplicates !
 (Set! subsystems (APPEND (self 'subsystems) aSubsystemList)) )

(defMethod (clearSubsystems! System) () (Set! subsystems nil))

(defMethod (clearBehaviour! System) () (Set! behaviour nil))

(defMethod (connections System) () 
   
  (define (removeDuplicatesFrom aList)
    (if (member (car aList) (cdr aList))
        (removeDuplicatesFrom (cdr aList)) 
        (begin (cons (car aList)
                     (if (null? aList)
                          nil
                         (removeDuplicatesFrom (cdr aList)))))))
    
   (RemoveDuplicatesFrom (Append (self 'inputs) (self 'outputs))) )

(defMethod (connections? System) ()
   (or (self 'inputs?) (self 'outputs?)))

(defMethod (show System) () 
  (display "==============================") (newline)
  (display "  SYSTEM: ")  
  (display (self 'name))  (newline)
  (display "==============================") (newline)
  (display " Inputs  : ") (display (self 'inputs))  (newline) 
  (display " Outputs : ") (display (self 'outputs)) (newline)
  (display " States  : ") (display (self 'states))  (newline)
  (If (self 'subsystems?)
      (begin (display " *** Subsystems *** ")     (newline) 
             (display "     ++++++++++     ")     (newline)
             (for-each (lambda (aSystem) 
                          (if (not (null? aSystem)) 
                              (begin (display (aSystem 'name)) (newline))))
                       (self 'subsystems))) )
  (If (self 'connections?)
      (begin (display " *** Connections *** ") (newline)
             (display "     +++++++++++     ") (newline)
             (display (self 'connections)) (newline)) )
  (If  (self 'behaviour?)
       (begin (display " *** Behaviour *** ") (newline)
              (display "     +++++++++     ") (newline)
              ((self 'behaviour) 'show) (newline))) ) 

; ***** Implementation of "BEHAVIOUR-EQNS"

(defFlavour BehaviourEqns (ako Vanilla) 
  (ivars stateEqns outputEqns) getivars setivars testivars)

(defMethod (addStateEqn! BehaviourEqns) (anExp)  
  (Set! stateEqns (append (list anExp) (self 'stateEqns))))

(defMethod (addOutputEqn! BehaviourEqns) (anExp)
  (Set! outputEqns (append (list anExp) (self 'outputEqns))))

(defMethod (show BehaviourEqns) ()
  (If (self 'stateEqns?) 
      (begin (display "State-Eqns") (newline)
             (display "----------") (newline)
             (for-each (lambda (x) (display x) (newline)) 
                       (self 'stateEqns)))
      (begin (display "No state eqns defined !") (newline)) )
   (If (self 'outputEqns?) 
      (begin (display "Output-Eqns") (newline)
             (display "-----------") (newline)
             (for-each (lambda (x) (display x) (newline)) 
                       (self 'outputEqns)))
      (begin (display "No output eqns defined !") (newline))) )




  
      