
object set is_a list.

   % This object provides set-processing operations, reusing much of list.

   :- override equal/2,          % equal([a,b], [b,a])
               included/3,       % included(b, [a,b], L), L=[a,b]
               union/3.          % union([a,b], [a,c], L), L=[b,a,c]
   :- publish  subset/2,         % subset([a,b,c], L),
                                 % (L=[a,b,c];L=[a,b];L=[a,c];...)
               is_subset/2.      % is_subset([c,a], [a,b,c])

   equal([], []).
   equal([X|Xs], Ys) :-
      ::excluded(X, Ys, Ys1),
      ::equal(Xs, Ys1).

   subset([], []).
   subset([X|Xs], [X|Ys]) :-
      ::subset(Xs, Ys).
   subset([_|Xs], Ys) :-
      ::subset(Xs, Ys).

   is_subset(Subset, Set) :-
      \+ ( ::member(X, Subset), \+ ::member(X, Set) ).

   included(X, [], [X]).
   included(X, [X|Xs], [X|Xs]).
   included(X, [Y|Xs], [Y|Ys]) :-
      X \== Y,
      this::included(X, Xs, Ys).

   union([], Ys, Ys).
   union([X|Xs], Ys, [X|Zs]) :-
      \+ ::member(X, Ys),
      ::union(Xs, Ys, Zs).
   union([X|Xs], Ys, Zs) :-
      ::member(X, Ys),
      ::union(Xs, Ys, Zs).

end_object set.


object ordered_list is_a list.

   % This object provides list-processing operations for ordered lists,
   % reusing most of list.

   :- override included/3,               % included(b, [a,c], L), L=[a,b,c]
               union/3.                  % union([a,b], [a,c], L), L=[a,a,b,c]
   :- publish  ordered/2,                % ordered([b,a], L), L=[a,b]
               ordered/3, partition/4,
               < /2, =< /2, >= /2, > /2. % a<b etc.
   :- unfold   < /2 in partition/4, =< /2 in partition/4,
               > /2 in partition/4, >= /2 in partition/4.

   included(X, [], [X]).
   included(X, [Y|Xs], [X,Y|Xs]) :-
      :: (X < Y).
   included(X, [Y|Xs], [Y|Ys]) :-
      :: (X >= Y),
      ::included(X, Xs, Ys).

   union([], Ys, Ys).
   union([X|Xs], [], [X|Xs]).
   union([X|Xs], [Y|Ys], [X|Zs]) :-
     :: (X < Y),
     ::union(Xs, [Y|Ys], Zs).
   union([X|Xs], [Y|Ys], [Y|Zs]) :-
     :: (X >= Y),
     ::union([X|Xs], Ys, Zs).

   ordered(Xs, SXs) :-
      ::ordered(Xs, SXs, []).

   ordered([], SXs, SXs).
   ordered([X|Xs], SXs, TailSXs) :-
      ::partition(Xs, X, Small, Large),
      ::ordered(Small, SXs, [X|SLarge]),
      ::ordered(Large, SLarge, TailSXs).

   partition([], _, [], []).
   partition([Y|Xs], X, [Y|Ys], Zs) :-
      :: (Y < X),
      ::partition(Xs, X, Ys, Zs).
   partition([Z|Xs], X, Ys, [Z|Zs]) :-
      :: (Z >= X),
      ::partition(Xs, X, Ys, Zs).

   X <  Y :- X @<  Y.
   X =< Y :- X @=< Y.
   X >= Y :- X @>= Y.
   X >  Y :- X @>  Y.

end_object ordered_list.


object key_list is_a ordered_list.

   % This object provides list-processing operations for lists ordered by
   % keys, reusing most of list and ordered_list.
   % Override key/2 in subobjects for lists with different keys, e.g.,
   % key(date(Month,Day,Year), Year/Month/Day) will order dates correctly.

   :- publish  key/2.
   :- override < /2, =< /2, > /2, >= /2.       % (1-a)<(2-a) etc.
                  % for included/3, ordered/2 etc.:
                  % included((3-b),[(1-a),(2-c)], L), L=[(1-a),(2-c),(3-b)]
   :- unfold   key/2 in < /2, key/2 in =< /2,
               key/2 in > /2, key/2 in >= /2,
               < /2 in partition/4, =< /2 in partition/4,
               > /2 in partition/4, >= /2 in partition/4.

   key(K-_, K).

   X <  Y :- ::key(X, XK), ::key(Y, YK), XK @<  YK.
   X =< Y :- ::key(X, XK), ::key(Y, YK), XK @=< YK.
   X >= Y :- ::key(X, XK), ::key(Y, YK), XK @>= YK.
   X > Y  :- ::key(X, XK), ::key(Y, YK), XK @>  YK.

end_object key_list.

