
:- format("~n * Call `sort_interface::start'.~2n", []).

% See lib/ui_objects.pl.ol for explanations about the framework object.


:- dynamic current_list/1, current_selected/2, current_number/1.

object sort_interface is_a user_interface.

   :- override views/1, buttons/1, sliders/1, outputs/1,
               values/1, window/3.

   views([(listTitle,LW,TH), (list,LW,LH),
          (sortedTitle,RW,TH), (sorted,RW,LH)]) :-
      LW = 30, RW = 30, TH = 30, LH = 200.

   buttons([(bt_number,"Add number"), (bt_delete,"Delete selected"),
            (bt_clear,"Delete all"), (bt_sort,"Sort"),
            (bt_quit,"Quit")]).

   sliders([(sl_number,"Number")]).

   outputs([(o_number,"1 ")]).

   values([current_list([]), current_selected(list,1), current_number(1)]).

   window(sort_win,
          "Sorting Numbers",
          vbox([space,
                hbox([vbox([output("List definition:"),
                      space,
                      vbox([bt_number,
                            hbox([bt_delete,bt_clear]),
                            space,
                            hbox([frame(Ssl_number),output(" 1..100:"),o_number])])]),
                      space,
                      vbox([output("Sorting:"),
                            space,
                            bt_sort,
                            space]),
                      space,space,space]),
                space,
                hbox([VlistTitle,VsortedTitle]),
                hbox([scroller(Vlist),scroller(Vsorted)]),
                hbox([vbox([space,bt_quit,space]),help])])) :-
      help <= text(3, 70, 3, "times6"),
      help => readonly,
      object(listTitle, VlistTitle),
      object(sortedTitle, VsortedTitle),
      object(list, Vlist),
      object(sorted, Vsorted),
      object(sl_number, Ssl_number).

   :- override init/1.

   % init(InitialState)
   init(list) :-
      this::init_list.

   init_list :-
      retractall(current_list(_)),
      retractall(current_selected(list,_)),
      assert(current_list([])),
      assert(current_selected(list,1)),
      set_selected(list, 1),
      list_title(0).

   :- override active_objects/2, help_text/2.

   active_objects(list, [bt_number,bt_delete,bt_clear,bt_quit,sl_number,list,bt_sort]).
   active_objects(sort, []).

   help_text(list,
             "Defining the list:
      Add number: add Number at selection.   Delete: delete selected or all.
      Number: select a number.   Click on number to select.
      Sort: sort the list.").
   help_text(sort,
             "Sorting ...").

   :- override handle_event/5.

   % select number in list
   handle_event(list, down(_,VView,_,Y), _, list, next) :-
      object(View, VView),
      position_index(View, Y, NewIndex),
      move_selected(View, NewIndex).
   % add number
   handle_event(list, button(_,bt_number), _, list, next) :-
      current_selected(list, Index),
      current_list(List),
      current_number(N),
      insert_in_list(N, Index, List, NewList),
      Index1 is Index+1,
      display_new_list(NewList, Index1),
      object(sorted, Vsorted),
      Vsorted => clear.
   % delete selected number
   handle_event(list, button(_,bt_delete), _, list, next) :-
      current_selected(list, Index),
      current_list(List),
      length(List, L),
      ( Index =< L ->
           delete_in_list(Index, List, NewList),
           display_new_list(NewList, Index),
           object(sorted, Vsorted), Vsorted => clear
         ;
           true
      ).
   % delete all numbers in list
   handle_event(list, button(_,bt_clear), _, list, next) :-
      object(list, Vlist),
      Vlist => clear,
      this::init_list,
      object(sorted, Vsorted), Vsorted => clear.
   % number slider
   handle_event(list, slider(_,Ssl_number,Value), _, list, next) :-
      object(sl_number, Ssl_number),
      LowerBound = 1, UpperBound = 100,
      N is LowerBound + integer(Value*(UpperBound-LowerBound)+0.5),
      change_one(current_number, N),
      name(N, NString),
      o_number => out(NString).
   % sort
 % handle_event(list, button(_,bt_sort), _, list, next) :-
 %    current_list(List),
 %    sort(List, SortedList),
 %    object(sorted, Vsorted), Vsorted => clear,
 %    display_list(SortedList, sorted, Vsorted, name(I,S), I, S, 1).
   % bt_quit and events not yet handled
   handle_event(State, Event, Window, NewState, Next) :-
      super::handle_event(State, Event, Window, NewState, Next).

end_object sort_interface.


% *** miscellaneous predicates

% list handling

% display_new_list(+List, +Index) -- display List; selection is at
%    Index
display_new_list(List, Index) :-
   change(current_list(_), current_list(List)),
   object(list, Vlist),
   Vlist => clear,
   display_list(List, list, Vlist, name(I,S), I, S, 1),
   set_selected(list, Index),
   length(List, L),
   list_title(L).

% display_list(+List, +VView, +Mapping, +Element, +String, +Index)
%    -- list elements of list in VView, starting at Index; Mapping is a goal that
%       maps Element to String
display_list([], _, _, _, _, _, _).
display_list([Item|L], View, VView, Mapping, Item1, String, Index) :-
   index_position(View, Index, Pos),
   \+ \+ ( Item1=Item, Mapping, VView => string(10, Pos, String) ),
   Index1 is Index+1,
   display_list(L, View, VView, Mapping, Item1, String, Index1).

insert_in_list(Num, 1, List, [Num|List]).
insert_in_list(Num, Index, [I|List], [I|NewList]) :-
   Index > 1,
   Index1 is Index-1,
   insert_in_list(Num, Index1, List, NewList).

% delete_in_list(+Index, +List, -NewList) -- delete the number at
%    Index in List
delete_in_list(1, [_|List], List).
delete_in_list(Index, [Num|List], [Num|NewList]) :-
   Index > 1,
   Index1 is Index-1,
   delete_in_list(Index1, List, NewList).
   
% list_title(+Length)
list_title(Length) :-
   send(listTitle, clear),
   send(listTitle, setfont("times10b")),
   send(listTitle, string(10, 14, "List:")),
   send(listTitle, setfont("times10i")),
   name(Length, LengthString),
   append(" (", LengthString, IS1), append(IS1, " numbers)", InfoString),
   send(listTitle, string(10, 1, InfoString)).

% set_selected(+View, +Index) -- set selection (rectangle) to Index
set_selected(View, Index) :-
   current_list(S), length(S, L),
   Rect = listSelection,
   ( Index > L -> NewIndex is L+1 ; NewIndex = Index ),
   change(current_selected(View,_), current_selected(View,NewIndex)),
   selection_position(View, NewIndex, Pos), Pos2 is Pos+12,
   object(View, VView),
   VView => rect(Rect, 5, Pos, 180, Pos2).

% move_selected(+View, +Index) -- move selection (rectangle) to Index
move_selected(View, Index) :-
   current_list(List), length(List, L),
   Rect = listSelection,
   ( Index > L -> NewIndex is L+1 ;
     Index < 1 -> NewIndex = 1 ;
                  NewIndex = Index
   ),
   change(current_selected(View,_), current_selected(View,NewIndex)),
   selection_position(View, NewIndex, Pos),
   object(View, VView),
   VView => moveto(Rect, 5, Pos).

% *** position - index calculations

% for the selection rectangle in the list view
selection_position(View, Index, Pos) :-
   top_positions(View, _, SP, _),
   Pos is SP - (Index-1)*12.

% for list lines in both views
index_position(View, Index, Pos) :-
   top_positions(View, IP, _, _),
   Pos is IP - (Index-1)*12.

position_index(View, Pos, Index) :-
   top_positions(View, _, _, IP),
   Index is (IP-Pos)//12 + 1.

% top_positions(+View, ItemPos, SelectionPos, IndexPos)
%    -- coordinates for various view items, given their respective view heights
top_positions(list,   185, 185, 198).
top_positions(sorted, 185, 185, 198).

append([], L, L).
append([X|Xs], Ys, [X|Zs]) :-
   append(Xs, Ys, Zs).

change(Old, New) :-
   retract(Old), assert(New),
   !.

change_one(Name, NewValue) :-
   Old =.. [Name,_],
   New =.. [Name,NewValue],
   retract(Old), assert(New),
   !.
