
% All objects accessed by `solve' have to have the declaration `:- dynamic'.

object listener is_a meta_object.

   :- publish solve/1, solve/2.

   % solve(+Object::Message) --
   %    solves Message with respect to Object, and traces the message traffic
   %    (this is a simple meta-interpreter restricted to conjunctions).

   solve(Object::Message) :-
      ::message(Object, prolog, loc, _, Message, MessageGoal),
      ::solve(MessageGoal, 0).

   solve((A,B), T) :-
      !,
      ::solve(A, T), ::solve(B, T).
   solve(MessageGoal, T) :-
      ::message(Receiver, Sender, _, _, Message, MessageGoal),
      !,
      this::trace_message_call(Sender, Receiver, Message, T),
      clause(MessageGoal, MethodHead),
      clause(MethodHead, Body),
      ( Body == true ->
           true
         ;
           T2 is T+2,
           ::solve(Body, T2)
      ),
      this::trace_message_exit(Sender, Receiver, Message, T).
   solve(PrologGoal, T) :-
      this::trace_prolog_call(PrologGoal, T),
      PrologGoal,
      this::trace_prolog_exit(PrologGoal, T).

   trace_message_call(Sender, Receiver, Method, T) :-
      ( tab(T), format("~w >> ~w: ~q~n", [Sender,Receiver,Method]) ;
        tab(T), format("~w -< ~w: ~q~n", [Sender,Receiver,Method]), fail ).

   trace_message_exit(Sender, Receiver, Method, T) :-
      ( tab(T), format("~w << ~w: ~q~n", [Sender,Receiver,Method]) ;
        tab(T), format("~w +> ~w: ~q~n", [Sender,Receiver,Method]), fail ).

   trace_prolog_call(Goal, T) :-
      ( tab(T), format("> prolog: ~q~n", [Goal]) ;
        tab(T), format("- prolog: ~q~n", [Goal]), fail ).

   trace_prolog_exit(Goal, T) :-
      ( tab(T), format("< prolog: ~q~n", [Goal]) ;
        tab(T), format("+ prolog: ~q~n", [Goal]), fail ).

end_object listener.
