#include "mem_macros.c"

#define MYPENUM 0

#define OsMyPeNum() MYPENUM

#define OsAllocTerm(size)\
SLOT *z;\
OsAllocTermFunc(size,&z)


/************************************************************************/
/*									*/
/*			Malloc Macro definitions			*/
/*									*/
/************************************************************************/


#define OsPrintf	printf
#define OsPrint		printf

#define Malloc_Real(p) 	  {  OsAllocTerm(1); 	p=(SHORT)(z - term_space);}
#define Malloc_Slots(p,n) {  OsAllocTerm(n); 	p=(SLOT *)z;}
#define Malloc_Block(p,n,T) OsAlloc(p,sizeof(char)*n,T)
#define Malloc_Query(p)	  OsAlloc(p,sizeof(QUERY),QUERY)
#define Malloc_Gslot(p)	  OsAlloc(p,sizeof(GOALSLOT),GOALSLOT)
#define Malloc_TskBk(p)	  OsAlloc(p,sizeof(TASKBK),TASKBK)
#define Malloc_Goal(p)	  OsAlloc(p,sizeof(GOAL),GOAL)
#define Malloc_Resp(p)	  OsAlloc(p,sizeof(RESPONSE),RESPONSE)
#define Malloc_Message(p) OsAlloc(p,sizeof(MESSAGE),MESSAGE)
#define Malloc_Chain(p)   OsAlloc(p,sizeof(CHAIN),CHAIN)
#define Malloc_Molecule(p) OsAlloc(p,sizeof(MOLECULE_PTR),MOLECULE_PTR)

#define Free_Real(ptr)		OsFreeTerm(ptr,1)
#define Free_Slots(ptr,n) 	OsFreeTerm(ptr,n) 
#define Free_Clause(ptr) 	OsFree(ptr,sizeof(CLAUSE))
#define Free_Block(ptr,n) 	OsFree(ptr,sizeof(char)*n)
#define Free_Query(ptr)		OsFree(ptr,sizeof(QUERY))
#define Free_Gslot(ptr)		OsFree(ptr,sizeof(GOALSLOT))
#define Free_TskBk(p)	  	OsFree(p,sizeof(TASKBK))
#define Free_Goal(ptr)		OsFree(ptr,sizeof(GOAL))
#define Free_Resp(ptr)		OsFree(ptr,sizeof(RESPONSE)) 
#define Free_Molecule(ptr)	OsFree(ptr,sizeof(MOLECULE_PTR)) 
#define Free_Chain(ptr) 	OsFree(ptr,sizeof(CHAIN))
#define Free_GoalMsg(ptr) 	{ if (MSGGOAL(ptr) != NULLPTR)\
					Free_Goal(MSGGOAL(ptr));\
				 OsFree(ptr,sizeof(MESSAGE));}
#define Free_RespMsg(ptr) 	{  \
				 OsFree(ptr,sizeof(MESSAGE));}
#define SET_P_C_MARKER()	PURE_CODE_MARKER=next_term


#define palloc(T,Count,Ptr)\
{\
    SHORT i;\
    OsAlloc(Ptr, (Count) * sizeof(T), T);\
    for (i = 0; i< (Count); i++)\
      Ptr[i] = (T) 0;\
}



/************************************************************************/
/*									*/
/*			Trace macro definition				*/
/*									*/
/************************************************************************/
/*
#ifdef DEBUG
#define TRACE(x) x
#else
#define TRACE(x)
#endif
*/
#define TRACE(x) if (DEBUG == TRUE) x
#define TRACE2(x) if (DEBUG2 == TRUE) x
