/*
 * graph.h
 * Header file for graph.c
 *
 * AUTHOR:  David Roch
 *
 * CONTRIBUTORS:
 *	DAR - David Roch
 *
 * HISTORY:
 *	08/01/88 - Created DAR
 */

#ifndef	H_GRAPH	/* if this file has not already been included */

#define H_GRAPH	1	/* indicate this file has been included */

#define	INDEPENDENT	0
#define	DEPENDENT	1

typedef struct NODES {
  SHORT		num_nodes;
  SHORT		*nd;
} NODES;
  
typedef struct SET {
  SHORT		num_lits;
  SLOT		*lits;
  SHORT		*lit_state_index;
  struct SET	*next;
} SET;

typedef struct SETLINK {
  VECTOR		*set;
  struct SETLINK	*next;
} SETLINK;

typedef struct LIT_LIST {
  SHORT			lit_index;
  struct LIT_LIST	*next;
} LIT_LIST;

/* attach(SHORT literal, node)
 * Attaches a literal to a candidate node.
 * Used to keep track of which literals may be executed from
 * a given node during graph generation.
 */
#define attach(literal, node) \
{ \
  LIT_LIST	*def_list; \
 \
  Malloc_Block(def_list, sizeof(LIT_LIST), LIT_LIST); \
  def_list->next = attached_lits [node]; \
  def_list->lit_index = literal; \
  attached_lits[node] = def_list; \
}

/* detach_lits(SHORT node)
 * Removes a LIT_LIST from a particular candidate node.
 * Effectively reinitializes the node.
 */
#define detach_lits(node) \
{ \
  LIT_LIST	*def_list1, \
  		*def_list2; \
 \
  def_list1 = attached_lits[node]; \
  while (def_list1 != NULL) { \
    def_list2 = def_list1; \
    def_list1 = def_list1->next; \
    Free_Block(def_list2); \
  } \
  attached_list[node] = NULL; \
}

#endif	/* end #if H_GRAPH */
