/* This file contains all the unification routines for the ROPM compiler */

#include "typedefs.h"
#include "macros.c"
#include "be_macros.c"
#include "seq_macros.c"

extern SLOT FUNCTOR_PLUS, FUNCTOR_MINUS, FUNCTOR_MULTIPLY;
extern SLOT FUNCTOR_DIV, FUNCTOR_DIVIDE, FUNCTOR_MOD;
extern SHORT CONS, NILATOMINDEX;


/* arg(I,T,X) : I is an instantiated index to a positive integer and T is
                instantiated to a compound term. "term" is the term "arg(..).
		Term1 in the code below is the Ith
                argument of term T. Term2 is the term bound to X. The
		two terms need to be unified.                           */

BOOLEAN BuiltinARG(term, tuple)
SLOT *term;
SLOT *tuple;
{
    SLOT *term1, *term2, *temp;
    SLOT *tuple1, *tuple2, temparray[500], *newtuple = temparray;
    SHORT i, tupsize;
    SHORT index;
    BOOLEAN DoUnification(), thrumolecule = FALSE; 
    MOLECULE_PTR *molecule;

    temp = term + 1;
    Deref_Term(temp, tuple);
    if (!TAG_IS_INTEGER(temp))
    {
	OsPrintf("illegal tag for index in BuiltinARG - aborting execution\n");
	exit(1);
    }
    index = INTVALUE(temp);

    term1 = term + 2;
    Deref_Term(term1, tuple);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    else tuple1 = newtuple;   /* not tuple, but newtuple - see below */
    if (ARITY(term1) < index  || index <= 0)
    {
	OsPrintf("index out of range in BuiltinArg - aborting execution\n");
	exit(1);
    }
    term1 = &term1[index];
    term2 = term + 3;
    tupsize = TUPLESIZE(tuple);
    if (tupsize > 500)
    {
	OsPrintf("tuple size too large in BuiltinARG - aborting execution\n");
	exit(1);
    }
    INSERT_TUPLE_SIZE(newtuple, tupsize);
    CopyTuple(newtuple, tuple);
    if (DoUnification(term1, tuple1, term2, newtuple, thrumolecule))
    {
	for (i = 1; i < tupsize; i++)
	    tuple[i] = newtuple[i];
	return TRUE;
    }
    else return FALSE;
}



BOOLEAN SeqBuiltinARG(term, tuple, TR, Stack, StackLimit)
SLOT *term;
SLOT *tuple;
LONG ***TR;
LONG *Stack;
LONG **StackLimit;
{
    SLOT *term1, *term2, *temp;
    SLOT *tuple1, *tuple2; 
    SHORT index;
    BOOLEAN DoSeqUnification(), thrumolecule = FALSE; 
    MOLECULE_PTR *molecule;

    temp = term + 1;
    Deref_Term(temp, tuple);
    if (!TAG_IS_INTEGER(temp))
    {
	OsPrintf("illegal tag for index in BuiltinARG - aborting execution\n");
	exit(1);
    }
    index = INTVALUE(temp);

    term1 = term + 2;
    Deref_Term(term1, tuple);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
	thrumolecule |= TRUE;
    }
    else if (TAG_IS_SEQ_MOLECULE(term1))
    {
	molecule = SEQ_MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
    }
    else tuple1 = tuple;
    if (ARITY(term1) < index  || index <= 0)
    {
	OsPrintf("index out of range in BuiltinArg - aborting execution\n");
	exit(1);
    }
    term1 = &term1[index];
    term2 = term + 3;
    return (DoSeqUnification(term1, tuple1, term2, tuple, thrumolecule, 
			     Stack, TR, StackLimit));
}


BOOLEAN BuiltinFUNCTOR(term, tuple, numchains, A)
SLOT *term;
SLOT **tuple;
SHORT numchains;
SLOT *A;  /* A registers */
{
    SLOT *newterm,*subterm, *func, *arity, *tupleptr = *tuple; 
    SHORT i, arityval, tupsize = TUPLESIZE(tupleptr);
    MOLECULE_PTR *molecule;
    char *GetAtom();

    subterm = term + 1;
    func = term + 2;
    arity = term + 3;
    Deref_Term(subterm, tupleptr);
    Deref_Term(func, tupleptr);
    Deref_Term(arity, tupleptr);
    if (TAG_IS_MOLECULE(subterm))
    {
	molecule = MOLECULE_ADDRESS(subterm);
	subterm = TERMS(molecule);
	tupleptr = TUPLE(molecule);
    }
    if (TAG_IS_FUNCTOR(subterm))
    {
	if (TAG_IS_FUNCTOR(func))
	{
	    if (!ARITY_IS_ZERO(func))
	    {
	        OsPrintf("illegal functor in BuiltinFUNCTOR - aborting execution\n");
		exit(1);
	    }
	    if (strcmp(GetAtom(GET_FUNCTOR(subterm)), GetAtom(GET_FUNCTOR(func))) != 0)  /* not the same */
	       return FALSE;
	}
	else if (TAG_IS_TUPLE_INDEX_1(func))   /* unbound variable */
	     INSERT_CLOSED_TERM(&((*tuple)[INDEX(func)]), 
			    AddProcName(GetAtom(GET_FUNCTOR(subterm)), 0), 0);
	else 
	{
	    OsPrintf("functor field has illegal slot tag in BuiltinFUNCTOR\n");
	    exit(1);
	}
	if (TAG_IS_INTEGER(arity))
	{
	    if (ARITY(subterm) != INTVALUE(arity))
	    {
		OsPrintf("arity mismatch in BuiltinFUNCTOR - aborting execution\n");
		exit(1);
	    }
	}
	else if (TAG_IS_TUPLE_INDEX_1(arity))   /* unbound variable */
	     INSERT_INTEGER(&((*tuple)[INDEX(arity)]), ARITY(subterm));
	else
	{
	    OsPrintf("arity field has illegal slot tag in BuiltinFUNCTOR\n");
	    exit(1);
	}
	return TRUE;
    }
    else if (TAG_IS_TUPLE_INDEX_1(subterm))
    {
	if (TAG_IS_FUNCTOR(func) && ARITY_IS_ZERO(func) &&
	    TAG_IS_INTEGER(arity) && INTVALUE(arity) >= 0)
	{
	    arityval = INTVALUE(arity);
	    /* extend the tuple */
	    if (*tuple == A)  /* can extend tuple in place */
	    {
		INSERT_TUPLE_SIZE(*tuple, (tupsize + arityval));
		for (i = tupsize; i < TUPLESIZE(*tuple); i++)
		    INSERT_SLOT_TAG(&((*tuple)[i]), UNBOUND_VAR);
	    }
	    else
	    {
		Malloc_ArcTuple(tupleptr, tupsize + arityval, numchains);
		INSERT_TUPLE_SIZE(tupleptr, tupsize + arityval);
		CopyTuple(tupleptr, (*tuple));
		for (i = tupsize; i < TUPLESIZE(tupleptr); i++)
		    INSERT_SLOT_TAG(&tupleptr[i], UNBOUND_VAR);
		*tuple = tupleptr;
	    }
	    /*  now to construct the new term */
	    Malloc_Slots(newterm, arityval + 1);
	    INSERT_FUNCTOR(newterm, AddProcName(GetAtom(GET_FUNCTOR(func)), arityval), arityval);
	    for (i = 0; i < arityval; i++)
	        INSERT_INDEX(&newterm[i+1], (tupsize + i), TUPLE_INDEX_1);
	    INSERT_ADDRESS(&((*tuple)[INDEX(subterm)]), newterm);
	}
	return TRUE;
    }
    else 
    {
	OsPrintf("term field has illegal slot tag in BuiltinFUNCTOR\n");
	exit(1);
    }
}



BOOLEAN SeqBuiltinFUNCTOR(term, tuple, TOS, TR, Stack, StackLimit)
SLOT *term;
SLOT *tuple;
LONG **TOS;
LONG ***TR;
LONG *Stack;
LONG **StackLimit;
{
    SLOT *newterm, *subterm, *func, *arity; 
    SHORT i, arityval, tupsize = TUPLESIZE(tuple);
    MOLECULE_PTR *molecule;
    char *GetAtom();

    subterm = term + 1;
    func = term + 2;
    arity = term + 3;

    Deref_Term(func, tuple);
    if (TAG_IS_TUPLE_INDEX_1(func))
       func = &tuple[INDEX(func)];
    Deref_Term(arity, tuple);
    if (TAG_IS_TUPLE_INDEX_1(arity))
       arity = &tuple[INDEX(arity)];
    Deref_Term(subterm, tuple);
    if (TAG_IS_MOLECULE(subterm))
    {
	molecule = MOLECULE_ADDRESS(subterm);
	subterm = TERMS(molecule);
	tuple = TUPLE(molecule);
    }
    else if (TAG_IS_SEQ_MOLECULE(subterm))
    {
	molecule = SEQ_MOLECULE_ADDRESS(subterm);
	subterm = TERMS(molecule);
	tuple = TUPLE(molecule);
    }
    else if (TAG_IS_TUPLE_INDEX_1(subterm))
       subterm = &tuple[INDEX(subterm)];

    if (TAG_IS_FUNCTOR(subterm))
    {
	if (TAG_IS_FUNCTOR(func))
	{
	    if (!ARITY_IS_ZERO(func))
	    {
	        OsPrintf("illegal functor in SeqBuiltinFUNCTOR - aborting execution\n");
		exit(1);
	    }
	    if (strcmp(GetAtom(GET_FUNCTOR(subterm)), GetAtom(GET_FUNCTOR(func))) != 0)  /* not equal */
	       return FALSE;
	}
	else if (TAG_IS_UNBOUND(func))
	{
	    *(*TR)++ = func;
	    INSERT_CLOSED_TERM(func, GET_FUNCTOR(subterm), 0);
	 }
	else 
	{
	    OsPrintf("functor field has illegal slot tag in SeqBuiltinFUNCTOR\n");
	    exit(1);
	}
	if (TAG_IS_INTEGER(arity))
	{
	    if (ARITY(subterm) != INTVALUE(arity))
	    {
		OsPrintf("arity mismatch in SeqBuiltinFUNCTOR - aborting execution\n");
		exit(1);
	    }
	}
	else if (TAG_IS_UNBOUND(arity)) 
	{
	    *(*TR)++ = arity;
	    INSERT_INTEGER(arity, ARITY(subterm));
	}
	else
	{
	    OsPrintf("arity field has illegal slot tag in SeqBuiltinFUNCTOR\n");
	    exit(1);
	}
	return TRUE;
    }
    else if (TAG_IS_UNBOUND(subterm))
    {
	if (TAG_IS_FUNCTOR(func) && ARITY_IS_ZERO(func) &&
	    TAG_IS_INTEGER(arity) && INTVALUE(arity) >= 0)
	{
	    arityval = INTVALUE(arity);
	    /* extend the tuple */
	    INSERT_TUPLE_SIZE(tuple, (tupsize + arityval));
	    *TOS += arityval; 
	    for (i = tupsize; i < TUPLESIZE(tuple); i++)
	        INSERT_SLOT_TAG(&tuple[i], UNBOUND_VAR);

	    ALLOC_SEQ_MOLECULE(subterm, molecule,*StackLimit);
	    *(*TR)++ = subterm;
	    /*  now to construct the new term */
	    *StackLimit -= (arityval + 1);
	    newterm = *StackLimit;
	    INSERT_FUNCTOR(newterm, AddProcName(GetAtom(GET_FUNCTOR(func)), arityval), arityval);
	    for (i = 0; i < arityval; i++)
	        INSERT_INDEX(&newterm[i+1], (tupsize + i), TUPLE_INDEX_1);
	    INSERT_MOLEC_TERMS(molecule, newterm);
	    INSERT_MOLEC_TUPLE(molecule, tuple);
	}
	return TRUE;
    }
    else 
    {
	OsPrintf("term field has illegal slot tag in SeqBuiltinFUNCTOR\n");
	exit(1);
    }
}




BOOLEAN NEqual(term1, term2, tuple)
SLOT *term1;
SLOT *term2;
SLOT *tuple;
{
    SLOT temparray[500], *copytuple = temparray;
    SHORT tupsize = TUPLESIZE(tuple);
    BOOLEAN Unify();

    if (tupsize > 500)
    {
        OsPrintf("tuple size too large in NEqual - aborting execution\n");
	exit(1);
    }
    INSERT_TUPLE_SIZE(copytuple, tupsize);
    CopyTuple(copytuple, tuple);
    return (!Unify(term1, copytuple, term2, copytuple, FALSE));
}




BOOLEAN BuiltinUNIV(term, tuple)
SLOT *term;
SLOT *tuple;
{
    SLOT *term1, *term2;
    SLOT *tuple1, *tuple2;
    SHORT i;
    MOLECULE_PTR *molecule;
    BOOLEAN thrumolecule, DoUnification();
    SLOT *temparray[500], *copytuple = (SLOT *) temparray;

    term1 = term + 1;
    Deref_Term(term1, tuple);
    term2 = term + 2;
    Deref_Term(term2, tuple);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
    }
    else tuple1 = tuple;
    if (TAG_IS_MOLECULE(term2))
    {
	molecule = MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
    }
    else tuple2 = tuple;
    if (TAG_IS_TUPLE_INDEX_1(term1))
    {
	if (TAG_IS_TUPLE_INDEX_1(term2))
	{
	    SLOT *newterm;
	    
	    Malloc_Slots(newterm, 3);
	    INSERT_FUNCTOR(newterm, CONS, 2); 
	    COPY_ATOM(&newterm[1], term1);
	    INSERT_CLOSED_TERM(&newterm[2], NILATOMINDEX,0);
	    INSERT_ADDRESS(&tuple2[INDEX(term2)], newterm);
	}
	else if (GET_FUNCTOR(term2) != CONS)
	    return(FALSE);
	else
	{
	    SHORT i, arity = 0;
	    SLOT *functor, *newterm, *temptuple;

	    /* compute arity of lhs term */
	    newterm = term2 + 2;
	    temptuple = tuple2;
	    while (GET_FUNCTOR(newterm) != NILATOMINDEX)
	    {
		arity++;
		Deref_Term(newterm, temptuple);
		if (TAG_IS_MOLECULE(newterm))
		{
		    molecule = MOLECULE_ADDRESS(newterm);
		    newterm = TERMS(molecule);
		    temptuple = TUPLE(molecule);
		}
		if (GET_FUNCTOR(newterm) != CONS)
		   return FALSE;
		newterm += 2;
	    }
	    functor = term2 + 1;
	    Deref_Term(functor, tuple2);

	    if (arity == 0 && (TAG_IS_INTEGER(functor) || TAG_IS_REAL(functor)))
	        COPY_ATOM(&tuple1[INDEX(term1)], functor);
	    else
	    {
		if (!(TAG_IS_FUNCTOR(functor) && ARITY_IS_ZERO(functor)))
	            return(FALSE);
		if (arity == 0)
	            COPY_ATOM(&tuple1[INDEX(term1)], functor);
		else
		{
		    Malloc_Slots(newterm, arity+1);
		    INSERT_FUNCTOR(newterm, AddProcName(GetAtom(GET_FUNCTOR(functor)), arity), arity);
		    for (i = 1; i <= arity; i++)
		    {
			term2 += 2;
			Deref_Term(term2, tuple2);
			COPY_SLOT(&newterm[i], &term2[1]);
		    }
		    INSERT_ADDRESS(&tuple1[INDEX(term1)], newterm);
		}
	    }
	}
    }
    else if (TAG_IS_TUPLE_INDEX_1(term2))
    {
	if ((TAG_IS_FUNCTOR(term1) && ARITY_IS_ZERO(term1)) ||
	      TAG_IS_INTEGER(term1) || TAG_IS_REAL(term1))
	{
	    SLOT *newterm;
	    
	    Malloc_Slots(newterm, 3);
	    INSERT_CLOSED_TERM(newterm, CONS, 2); 
	    COPY_ATOM(&newterm[1], term1);
	    INSERT_CLOSED_TERM(&newterm[2], NILATOMINDEX,0);
	    INSERT_ADDRESS(&tuple2[INDEX(term2)], newterm);
	}
	else if (!TAG_IS_FUNCTOR(term1))
	     return FALSE;
	else
	{
	    SHORT i, arity = ARITY(term1);
	    SLOT *newterm;
	    
	    Malloc_Slots(newterm, (2*(arity + 1) + 1));
	    INSERT_FUNCTOR(newterm, CONS, 2);
	    INSERT_CLOSED_TERM(&newterm[1], GET_FUNCTOR(term1), 0);
	    for (i = 1; i <= arity; i++)
	    {
		INSERT_FUNCTOR(&newterm[2*i], CONS, 2);
		COPY_SLOT(&newterm[2*i + 1], &term1[i]);
	    }
	    INSERT_CLOSED_TERM(&newterm[2*(arity+1)], NILATOMINDEX,0);
	    INSERT_ADDRESS(&tuple2[INDEX(term2)], newterm); 
	}
    }
    else    	/* both are bound */
    {
	SHORT count = 0;
	SLOT *subterm, *temptuple;
			
	if (GET_FUNCTOR(term2) != CONS)
	   return FALSE;
	/* we are now interested in the rest of the list */
	/* compute length of list */
	subterm = term2 + 2;
	temptuple = tuple2;
	while (GET_FUNCTOR(subterm) != NILATOMINDEX)
	{
	    count++;
	    Deref_Term(subterm, temptuple);
	    if (TAG_IS_MOLECULE(subterm))
	    {
		molecule = MOLECULE_ADDRESS(subterm);
		subterm = TERMS(molecule);
		temptuple = TUPLE(molecule);
	    }
	    if (GET_FUNCTOR(subterm) != CONS)
	        return FALSE;
	    subterm += 2;
	}

	if (count == 0)
	{
	    if (!((TAG_IS_FUNCTOR(term1) && ARITY_IS_ZERO(term1)) ||
		  TAG_IS_INTEGER(term1) || TAG_IS_REAL(term1)))
	    return FALSE;
	}
	else if (!TAG_IS_FUNCTOR(term1) || (ARITY(term1) != count))
	    return FALSE;
	else
	{
	    SLOT *functor, *subterm1, *subterm2;
	    
	    functor = &term2[1];
	    Deref_Term(functor, tuple2);
	    if (!(TAG_IS_FUNCTOR(functor) && ARITY_IS_ZERO(functor)))
		 return FALSE;
	    if (TUPLESIZE(tuple) > 500)
	    {
		OsPrintf("tuple size too large in BuiltinUNIV - aborting execution\n");
		exit(1);
	    }
	    INSERT_TUPLE_SIZE(copytuple, TUPLESIZE(tuple));
	    CopyTuple(copytuple, tuple);

	    /* now use copytuple - in case unification fails */
	    for (term2 += 2, i = 1; i <= count; i++)
	    {
		thrumolecule = FALSE;
		subterm1 = term1+i;
		Deref_Term(term2, copytuple);
		if (TAG_IS_MOLECULE(term2))
		{
		    molecule = MOLECULE_ADDRESS(term2);
		    term2 = TERMS(molecule);
		    tuple2 = TUPLE(molecule);
		    thrumolecule = TRUE;
		}
		else tuple2 = copytuple;
		subterm2 = term2 + 1;
		if (!DoUnification(subterm1, copytuple, subterm2, tuple2, thrumolecule))
		    return FALSE;
		term2 += 2;
	    }
	    for (i = 1; i < TUPLESIZE(tuple); i++)  /* unif. successful */
	        tuple[i] = copytuple[i];
	}  /* else */
    }   /* else both are bound */
    return(TRUE);
}




BOOLEAN SeqBuiltinUNIV(term, tuple, TR, Stack, StackLimit)
SLOT *term;
SLOT *tuple;
LONG ***TR;
LONG *Stack;
LONG **StackLimit;
{
    SLOT *term1, *term2;
    SLOT *tuple1, *tuple2;
    SHORT i;
    MOLECULE_PTR *molecule;
    BOOLEAN thrumolecule, DoSeqUnification();
    SLOT *temparray[500], *copytuple = (SLOT *) temparray;

    term1 = term + 1;
    Deref_Term(term1, tuple);
    term2 = term + 2;
    Deref_Term(term2, tuple);
    if (TAG_IS_MOLECULE(term1))
    {
	molecule = MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
    }
    else if (TAG_IS_SEQ_MOLECULE(term1))
    {
	molecule = SEQ_MOLECULE_ADDRESS(term1);
	term1 = TERMS(molecule);
	tuple1 = TUPLE(molecule);
    }
    else tuple1 = tuple;
    if (TAG_IS_MOLECULE(term2))
    {
	molecule = MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
    }
    else if (TAG_IS_SEQ_MOLECULE(term2))
    {
	molecule = SEQ_MOLECULE_ADDRESS(term2);
	term2 = TERMS(molecule);
	tuple2 = TUPLE(molecule);
    }
    else tuple2 = tuple;

    if (TAG_IS_TUPLE_INDEX_1(term1))
        term1 = &tuple1[INDEX(term1)];

    if (TAG_IS_TUPLE_INDEX_1(term2))
        term2 = &tuple2[INDEX(term2)];

    if (TAG_IS_UNBOUND(term1))
    {
	if (TAG_IS_UNBOUND(term2))
	{
	    SLOT *newterm;

	    ALLOC_SEQ_MOLECULE(term2, molecule,*StackLimit);
	    *(*TR)++ = term2;
	    *StackLimit -= 3;
	    newterm = *StackLimit;
	    INSERT_FUNCTOR(newterm, CONS, 2); 
	    COPY_ATOM(&newterm[1], term1);
	    INSERT_CLOSED_TERM(&newterm[2], NILATOMINDEX, 0);
	    INSERT_MOLEC_TERMS(molecule, newterm);
	    INSERT_MOLEC_TUPLE(molecule, tuple1);
	}
	else if (GET_FUNCTOR(term2) != CONS)
	    return(FALSE);
	else
	{
	    SHORT i, arity = 0;
	    SLOT *functor, *newterm, *temptuple;

	    /* compute arity of lhs term */
	    newterm = term2 + 2;
	    temptuple = tuple2;
	    while (GET_FUNCTOR(newterm) != NILATOMINDEX)
	    {
		arity++;
		Deref_Term(newterm, temptuple);
		if (TAG_IS_MOLECULE(newterm))
		{
		    molecule = MOLECULE_ADDRESS(newterm);
		    newterm = TERMS(molecule);
		    temptuple = TUPLE(molecule);
		}
		else if (TAG_IS_SEQ_MOLECULE(newterm))
		{
		    molecule = SEQ_MOLECULE_ADDRESS(newterm);
		    newterm = TERMS(molecule);
		    temptuple = TUPLE(molecule);
		}
		if (GET_FUNCTOR(newterm) != CONS)
		   return FALSE;
		newterm += 2;
	    }
	    functor = term2 +1;
	    Deref_Term(functor, tuple2);

	    if (arity == 0 && (TAG_IS_INTEGER(functor) || TAG_IS_REAL(functor)))
	    {
	        COPY_ATOM(term1, functor);
		*(*TR++)++ = term1;
	    }
	    else
	    {
		if (!(TAG_IS_FUNCTOR(functor) && ARITY_IS_ZERO(functor)))
	            return(FALSE);

		*(*TR++)++ = term1;
		if (arity == 0)
	            COPY_ATOM(term1, functor);
		else
		{
		    ALLOC_SEQ_MOLECULE(term1, molecule,*StackLimit);
		    *StackLimit -= (arity+1);
		    newterm = *StackLimit;
		    INSERT_FUNCTOR(newterm, AddProcName(GetAtom(GET_FUNCTOR(functor)), arity), arity);
		    for (i = 1; i <= arity; i++)
		    {
			term2 += 2;
			Deref_Term(term2, tuple2);
			COPY_SLOT(&newterm[i], &term2[1]);
		    }
		    INSERT_MOLEC_TERMS(molecule, newterm);
		    INSERT_MOLEC_TUPLE(molecule,tuple2);
		}
	    }
	}
    }
    else if (TAG_IS_UNBOUND(term2))
    {
	if ((TAG_IS_FUNCTOR(term1) && ARITY_IS_ZERO(term1)) ||
	     TAG_IS_INTEGER(term1) || TAG_IS_REAL(term1))
	{
	    SLOT *newterm;

	    Malloc_Slots(newterm, 3);
	    INSERT_CLOSED_TERM(newterm, CONS, 2); 
	    COPY_ATOM(&newterm[1], term1);
	    INSERT_CLOSED_TERM(&newterm[2], NILATOMINDEX,0);
	    INSERT_ADDRESS(term2, newterm);
	    *(*TR++)++ = term2;
	}
	else
	{
	    SHORT i, arity = ARITY(term1);
	    SLOT *newterm;

	    ALLOC_SEQ_MOLECULE(term2,molecule,*StackLimit);
	    *(*TR++)++ = term2;
	    *StackLimit -= (2*(arity + 1) + 1);
	    newterm = *StackLimit;
	    INSERT_FUNCTOR(newterm, CONS, 2);
	    INSERT_CLOSED_TERM(&newterm[1], GET_FUNCTOR(term1), 0);
	    for (i = 1; i <= arity; i++)
	    {
		INSERT_FUNCTOR(&newterm[2*i], CONS, 2);
		COPY_SLOT(&newterm[2*i + 1], &term1[i]);
	    }
	    INSERT_CLOSED_TERM(&newterm[2*(arity+1)], NILATOMINDEX,0);
	    INSERT_MOLEC_TERMS(molecule, newterm);
	    INSERT_MOLEC_TUPLE(molecule, tuple1);
	}
    }
    else    	/* both are bound */
    {
	SHORT count = 0;
	SLOT *subterm, *temptuple;

	if (GET_FUNCTOR(term2) != CONS)
	    return(FALSE);

	/* we are now interested in the rest of the list */
	/* compute length of list */
	subterm = term2 + 2;
	temptuple = tuple2;
	while (GET_FUNCTOR(subterm) != NILATOMINDEX)
	{
	    count++;
	    Deref_Term(subterm, temptuple);
	    if (TAG_IS_MOLECULE(subterm))
	    {
		molecule = MOLECULE_ADDRESS(subterm);
		subterm = TERMS(molecule);
		temptuple = TUPLE(molecule);
	    }
	    else if (TAG_IS_SEQ_MOLECULE(subterm))
	    {
		molecule = SEQ_MOLECULE_ADDRESS(subterm);
		subterm = TERMS(molecule);
		temptuple = TUPLE(molecule);
	    }
	    if (GET_FUNCTOR(subterm) != CONS)
	        return FALSE;
	    subterm += 2;
	}
	if (count == 0)
	{
	    if (!((TAG_IS_FUNCTOR(term1) && ARITY_IS_ZERO(term1)) ||
		  TAG_IS_INTEGER(term1) || TAG_IS_REAL(term1)))
	    return FALSE;
	}
	else if (!TAG_IS_FUNCTOR(term1) || (ARITY(term1) != count))
	    return FALSE;
	else
	{
	    SLOT *functor, *subterm1, *subterm2;

	    functor = &term2[1];
	    Deref_Term(functor, tuple2);
	    if (!(TAG_IS_FUNCTOR(functor) && ARITY_IS_ZERO(functor)))
		 return FALSE;
	    /* don't need copytuple in sequential version: will backtrack */
	    for (term2 += 2, i = 1; i <= count; i++)
	    {
		thrumolecule = FALSE;
		subterm1 = term1 + i;
		Deref_Term(term2, tuple2);
		if (TAG_IS_MOLECULE(term2))
		{
		    molecule = MOLECULE_ADDRESS(term2);
		    term2 = TERMS(molecule);
		    tuple2 = TUPLE(molecule);
		    thrumolecule = TRUE;
		}
		else if (TAG_IS_SEQ_MOLECULE(term2))
		{
		    molecule = SEQ_MOLECULE_ADDRESS(term2);
		    term2 = TERMS(molecule);
		    tuple2 = TUPLE(molecule);
		}
		subterm2 = term2 + 1;
		if (!DoSeqUnification(subterm1, tuple1, subterm2, tuple2, 
				      thrumolecule, Stack, TR, StackLimit))
		    return FALSE;
		term2 += 2;
	    }
	}  /* else */
    }   /* else both are bound */
    return(TRUE);
}



