/*
 *	sm - convert to sequent makefile syntax
 *
 * this utility reads a normal makefile and writes a sequent parallel makefile 
 * to stdout.  to run a makefile in parallel on sequent, the ':' following a
 * target must be changed to ':&', and all the actions for the target must
 * be on one line.  an example of the translation done by this program:
 *
 *	    fib.o:	fib.c
 *           cp distribute/fib.c .
 *           cc -c fib.c
 *           rm fib.c
 *
 * becomes
 *
 *     fib.o:&  fib.c
 *           cp distribute/fib.c . \
 *           cc -c fib.c \
 *           rm fib.c
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define STRMAX 1000

char s[STRMAX];
FILE *MF;
int eofflag;

main(argc,argv)
int argc;
char **argv;
{
	if (argc == 1) {
		printf("Usage: sm mfname\n");
		printf("where mfname is the name of the makefile\n");
		exit(1);
	}
	MF = fopen(argv[1],"r");
	if (MF == NULL) {
		perror(argv[1]);
		exit(1);
	}
	eofflag = 0;
	ProcessFiles();
	fclose(MF);
}

	
ProcessFiles()
{
	GetDep();
	while (!eofflag) {
		ProcActions();
		GetDep();
	}
}

ProcActions()
{
	char olds[STRMAX];

	GetLine();
	if (eofflag) return;
	if (BlankLine()) { printf("\n"); return; }

	for (;;) {
		strcpy(olds,s);
		GetLine();
		/* eof or blank line terminates the action list.  write the buffered
		 * line, and a blank line if terminated by blank line; and exit.
		 */
		if (eofflag || BlankLine()) {
			printf("%s\n", olds);
			if (!eofflag) printf("\n");
			break;
		}
		else {
			printf("%s ; \\\n",olds);
		}
	}
}

GetDep()
{
	/* scan and pass lines up to the next dependency line.  also process this
	 * line by inserting & after the colon.  if a continued dependency line
	 * (last nonblank = \), pass those lines as well.
	 */
	char *colon;

	for(;;) {
		GetLine();
		if (eofflag) break;
		colon = (char *)index(s,':');
		if (colon == NULL) {
			puts(s);
			continue;
		}

		/* got a dependency line.  process it and any continuations
		 */
		*colon = '\0';
		printf("%s:&	%s\n", s, colon+1);
		*colon = ':';
		while (!eofflag && ContinuedLine()) {
			GetLine();
			if (!eofflag) puts(s);
		}
		break;
	}
}

GetLine()
{
	char *p;

	if (fgets(s, STRMAX, MF) == NULL) {
		eofflag = 1;
		return;
	}
   /* MAY WHOEVER WROTE FGETS BURN IN HELL FOREVER */
	p = (char *)index(s,'\n');
	if (p) *p = '\0';

	for (p = s; *p; p++)
		if (!isspace(*p))
			if ( *p == '#' ) {
				fputs(s);
				GetLine();
				return;
			}
			else return;
}

BlankLine()
{
	char *p;

	for (p = s; *p; p++)
		if (!isspace(*p))
			return 0;
	return 1;
}

ContinuedLine()
{
	/* return 1 if current line is continued and 0 if not continued.
	 * checks if last nonblank character in the line is \
	 */
	int len;
	char c;

	if ((len = strlen(s)) == 0) return 0;
	while (len > 0) {
		c = s[--len];
		if (!isspace(c)) break;
	}
	return c == '\\';
}
