/*
 *		chare kernel entry point
 *
 *		spawns parallel copies of loop().
 */

#include <stdio.h>
#include <signal.h>
#include "cksys.h"
#include "host.h"

int numPe = 1;			/* parallel processors to apply to loop() */
extern int SysMem;
int Millisec;			/* elapsed real time */
SPINLOCK countlock;

main(argc,argv)
{
	int main2();

	ParseCommandOptions(argc,argv);
	if( task_init( SysMem*numPe+1500000, numPe, main2, 10000, 2, argc, argv ) != 0 ) {
		printf("INIT: task_init failure\n");
		fflush(stdout);
		exit(1);
	};
	WriteStats();
	exit(0);
}

main2(argc,argv)
int argc; char **argv;
{
   int i, main3(), OsInterrupt();
	extern int ElapsedTimes[];

   McInit();
   OsSpinInit(countlock);

   /*=== fork NumPe processes */
	OsInitial();
	UsrHostInit(argc,argv);
	UsrNodeInit(argc,argv);
   for (i=0; i<numPe; i++)
	if( task_start( main3, 20000, 1, i ) == NULL )
		OsPrintf("INIT: failed to start pe #%d\n", i );
   task_join();
	Millisec = 0;
	for( i=0; i<numPe; i++ ) {
		if( ElapsedTimes[i] > Millisec ) Millisec = ElapsedTimes[i];
	}
}

main3(penum)
int penum;
{
	int lPenum;

	lPenum = penum;
	loop(lPenum);
}


WriteStats()
{
	CkStats();
	OsPrintf("%d ms elapsed time\n", Millisec );
}
