#include "chare.h"
#include "machine.h"
#include "extern.h"

/*#define ROUTE */
#define MSGPASSING

OsKillMyself()
{
    int	  peNum = McMyPeNum();

    CHARESTAT(PE(peNum).myChareBlk)= CHARETYPE_KILL;
    PE(peNum).currentChare--;
}

OsMyPeNum()
{
    return(McMyPeNum());
}

CHAREBLK *OsMyChNum()
{
    int	  peNum = McMyPeNum();

    return(PE(peNum).myChareBlk);
}

OsKillSys()
{
    McKillSys();
}

OsGetSysClk()
{
    return(McGetSysClk(McMyPeNum()));
}


SYSMSG *OsNextWork(codeP,dataPP,msgPP)
USRMSG **msgPP;
int **dataPP;
int *codeP;
{
    int	     i,k,peNum=McMyPeNum(),*infPtr;
    SYSMSG   *mPtr,*newPtr,*CreateSysMsg(),*QmGetUsrMsg();
    CHAREBLK *CreateChareBlk();
    CHAREID  *idPtr;

    clock_off();

    mPtr = QmGetUsrMsg(peNum); 
    
    if (ip.TraceOn == 2 || ip.TraceOn == 4) {
	k = McGetSysClk();
	printf("-  %6d  pe.%2d: ",k,peNum);
	for (i = 1; i <= ip.PEnum; i++)
	    printf(" %2d,%-2d,%-2d ",PE(i).inChareQ.qLen,
	     PE(i).inDataQ.qLen,PE(i).newLoad);
	printf("%5d %x\n",mPtr,SYSMSGDESTCH(mPtr)); fflush(stdout);
	}

    clock_on();
    co_time_off(k);

    if (SYSMSGTYPE(mPtr) == SYSMSGTYPE_CHAR) {
	/* keep network,os information here */
	PE(peNum).myChareBlk = CreateChareBlk(SYSMSGSRCPE(mPtr),
				SYSMSGSRCCH(mPtr),CHARETYPE_IDLE,
				SYSMSGUCDS(mPtr));
	PE(peNum).currentChare++;
	*dataPP		= CHARECDPTR(PE(peNum).myChareBlk);
#ifdef ORACLESIM
	for (i=0; i <= MAXHOPS; i++) {
	    CHARESYSDATA(PE(peNum).myChareBlk,i) = SYSMSGPATH(mPtr,i);
	    } 
 	CHARESYSDATA(PE(peNum).myChareBlk,0) = SYSMSGHOPS(mPtr);
    	/* record information about # of hops taken for goal msg */
	op.hopsNum += SYSMSGHOPS(mPtr);
    	if (SYSMSGHOPS(mPtr) >= MAXHOPS) 
    	    op.hopsTaken[MAXHOPS] += 1; 
        else
    	    op.hopsTaken[SYSMSGHOPS(mPtr)] += 1; 
#endif
	PE(peNum).chareNumConsumed++;
	if ((idPtr=SYSMSGLOGICID(mPtr)) != NULLPTR) {
	    if (SYSMSGSRCPE(mPtr) != peNum) {
	        newPtr = CreateSysMsg(SYSMSGTYPE_PECH,0,NULLPTR,
				peNum,PE(peNum).myChareBlk,
				SYSMSGSRCPE(mPtr),SYSMSGSRCCH(mPtr),
				SYSMSGSRCPE(mPtr),
				FALSE,sizeof(SYSMSG),0,0,idPtr,NULLPTR);
	        McSendMsg(newPtr,peNum);
		}
	    else {
		idPtr->remotePE = peNum;
		idPtr->remoteCH = (int) PE(peNum).myChareBlk;
		while (idPtr->pendingMsg.head != NULLPTR) {
		    newPtr = (SYSMSG*)QmDeQueue(&idPtr->pendingMsg);
		    SYSMSGDESTPE(newPtr) = SYSMSGNEXTPE(newPtr) = peNum;
		    SYSMSGDESTCH(newPtr) = PE(peNum).myChareBlk;
		    QmPutLocalMsg(newPtr,peNum);
		    }
		}
	    }
	}
    else {
 	PE(peNum).myChareBlk 	= SYSMSGDESTCH(mPtr);
	*dataPP 	= CHARECDPTR(PE(peNum).myChareBlk);  
	PE(peNum).dataNumConsumed++;
	}

    McSeparateMsg(mPtr);

    /* extract real message for interpreter */
    *codeP = SYSMSGUCODE(mPtr);
    *msgPP = (USRMSG *) SYSMSGUPTR(mPtr);

    fflush(stdout);
    co_time_on(k);
    return(mPtr);
}

void OsFirstChare(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,msgCDsize)
USRMSG *ptrUsrMsg;
int    msgCode;
int    msgSize;
int    msgPrio;
int    msgPack;
int    msgCDsize;
{
    int		i,k,peNum;
    SYSMSG	*mPtr, *ExtendSysMsg();
    CHAREBLK	*cPtr, *CreateChareBlk(); 

    cPtr = CreateChareBlk(NULL,NULL,CHARETYPE_IDLE,0);
    mPtr = ExtendSysMsg(SYSMSGTYPE_CHAR,msgCode,ptrUsrMsg,
			STARTSRCPE,cPtr,STARTDESTPE,NULLPTR,STARTDESTPE,
			msgPack,/*msgSize+*/sizeof(SYSMSG),msgSize,msgCDsize,
			NULLPTR,NULLPTR);
#ifdef ORACLESIM
    CHARESYSDATA(cPtr,0) = SYSMSGPATH(mPtr,0);
    CHARESYSDATA(cPtr,1) = SYSMSGPATH(mPtr,1);
#endif

    /*McSend1stMsg(mPtr);*/
    McSendMsg(mPtr,STARTSRCPE);
}

OsNewChare1(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,msgCDsize,
		idPtr,idBack,destPE)
USRMSG *ptrUsrMsg;
int    msgCode;
int    msgSize;
int    msgPrio;
int    msgPack;
int    msgCDsize;
CHAREID *idPtr;
int    idBack;
int    destPE;
{
    int		i,k,peNum=McMyPeNum();
    SYSMSG	*mPtr, *CreateSysMsg();

    co_time_off(k);
    op.chareNum++;
    PE(peNum).chareNumGenerated++;

    if (idBack) {
	/*if (PE(peNum).logicIdx >= MAXLOGICID) {
	    printf("Too many logic chare ID\n");
	    OsKillSys();
	    }
	backIdIdx = PE(peNum).logicIdx++;
	*/
        idPtr->pendingMsg.head	= NULLPTR;
        idPtr->pendingMsg.tail	= NULLPTR;
        idPtr->pendingMsg.qLen	= 0;
        idPtr->pendingMsg.maxLen	= 0;
        idPtr->remotePE		= DUMMY;
        idPtr->remoteCH		= DUMMY;
	}
	
    mPtr = ExtendSysMsg(SYSMSGTYPE_CHAR,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,-1,-1,-1,
			msgPack,sizeof(SYSMSG),msgSize,msgCDsize,
			idPtr,NULLPTR);
    co_time_on(k);
#ifdef SHAREDMEM
	SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = peNum;
	McSendMsg(mPtr,peNum);
#else
    if (destPE == DUMMY)
        LdbNewChare(mPtr);
    else {
	SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = destPE;
	McSendMsg(mPtr,peNum);
	}
#endif

    clock_off();
    if (ip.TraceOn == 2 || ip.TraceOn == 4) {
	k = McGetSysClk();
	printf(">g %6d  pe.%2d: ",k,peNum);
	for (i = 1; i <= ip.PEnum; i++)
	    printf(" %2d,%-2d,%-2d ",PE(i).inChareQ.qLen,
	     PE(i).inDataQ.qLen,PE(i).newLoad);
	printf("%5d %x\n",mPtr,SYSMSGDESTCH(mPtr)); fflush(stdout);
	}
/*    CoMsgNoWait(peNum);  turn on when CWN applied */

    clock_on();
}

void OsSendMsgParent(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack)
USRMSG *ptrUsrMsg;
int    msgCode;
int    msgSize;
int    msgPrio;
int    msgPack;
{
    int peNum = McMyPeNum();

    OsSendMsg(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,
    	CHAREPAPE(PE(peNum).myChareBlk),CHAREPACH(PE(peNum).myChareBlk));
}

void OsSendMsgLogic(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,idPtr)
USRMSG *ptrUsrMsg;
int    msgCode;
int    msgSize;
int    msgPrio;
int    msgPack;
CHAREID    *idPtr;
{
    int 	peNum = McMyPeNum();
    SYSMSG	*mPtr,*CreateSysMsg();

    if (idPtr == NULLPTR ) {
	printf("Incorrect logic ID \n");
	OsKillSys();
	}
    if (idPtr->remotePE == DUMMY) {
    	mPtr = ExtendSysMsg(SYSMSGTYPE_DATA,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,DUMMY,DUMMY,DUMMY,
			msgPack,sizeof(SYSMSG),msgSize,0,NULLPTR,NULLPTR);
	InsertL(&idPtr->pendingMsg,mPtr);
/*** need more work for ORACLE ***/
	}
    else {
        OsSendMsg(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,
    	    idPtr->remotePE,idPtr->remoteCH);
	}
}

OsSendMsg(msgCode,ptrUsrMsg,msgSize,msgPrio,msgPack,destPE,destCB)
USRMSG *ptrUsrMsg;
int    msgCode;
int    msgSize;
int    msgPrio;
int    msgPack;
int    destPE, destCB;
{
    int		i,k,busNum=0;
    SYSMSG	*mPtr, *ExtendSysMsg();
    int 	peNum=McMyPeNum(),nextNum=destPE,distNum=0,*ptrPath=0;

    op.dataNum++;
    PE(peNum).dataNumGenerated++;

    co_time_off(k);

/*printf("\npe%d at%d send msg to %d ",peNum,OsGetSysClk(),destPE); */
    if (peNum == destPE) {
#ifdef ORACLESIM
      mPtr = ExtendSysMsg(SYSMSGTYPE_DATA,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,destPE,destCB,peNum,
			FALSE,sizeof(SYSMSG),msgSize,0,NULLPTR,
			&CHARESYSDATA(PE(peNum).myChareBlk,0));
#else
      mPtr = ExtendSysMsg(SYSMSGTYPE_DATA,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,destPE,destCB,peNum,
			FALSE,sizeof(SYSMSG),msgSize,0,NULLPTR,
			NULLPTR);
#endif
      co_time_on(k);
      QmPutLocalMsg(mPtr,peNum);
     }
    else {

#ifdef ORACLESIM
#ifdef ROUTE
     find_route(ip.TOPOtype, peNum, destPE, &nextNum, &busNum);
#else
     if (PE(peNum).myChareBlk == NULL) printf("myChareBlk is null\n");
     ptrPath = (int *) &CHARESYSDATA(PE(peNum).myChareBlk,0);
     distNum = ptrPath[0];
     nextNum = (distNum <= 0) ? destPE : ptrPath[distNum];
#endif
      if (destPE != nextNum)
    	mPtr = ExtendSysMsg(SYSMSGTYPE_ROUT,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,destPE,destCB,nextNum,
			msgPack,msgSize+sizeof(SYSMSG),msgSize,0,NULLPTR,ptrPath);
      else 
#endif 
    	mPtr = ExtendSysMsg(SYSMSGTYPE_DATA,msgCode,ptrUsrMsg,
			peNum,PE(peNum).myChareBlk,destPE,destCB,nextNum,
			msgPack,sizeof(SYSMSG),msgSize,0,NULLPTR,ptrPath);
     if (distNum > 1) SYSMSGHOPS(mPtr) -= 1;
     co_time_on(k);
     McSendMsg(mPtr,peNum,busNum);
     }

    clock_off();

    if (ip.TraceOn == 2 || ip.TraceOn == 4) {
	k = McGetSysClk();
	printf(">r %6d  pe.%2d: ",k,peNum);
	for (i = 1; i <= ip.PEnum; i++)
	    printf(" %2d,%-2d,%-2d ",PE(i).inChareQ.qLen,
	     PE(i).inDataQ.qLen,PE(i).newLoad);
	printf("%5d %x\n",mPtr,SYSMSGDESTCH(mPtr)); fflush(stdout);
	}
/*    CoMsgNoWait(peNum);  turn on when CWN applied */

    clock_on();
}


Loop(peNum)
int peNum;
{
    SYSMSG *m,*OsNextWork();
    USRMSG *usrPtr;
    int    i,code,*dataP;

    McInitClk(peNum); 
    while ((m = OsNextWork(&code,&dataP,&usrPtr)) != NULL) {
	UsrPrg(code,usrPtr,dataP);
	if (PE(peNum).myChareBlk->chareStat == CHARETYPE_KILL)
	    Free_Block(PE(peNum).myChareBlk,
			sizeof(CHAREBLK)+PE(peNum).myChareBlk->cdataSize);
/*
	Free_Block(m,SYSMSGSIZE(m));
	Free_Block(m,sizeof(SYSMSG));
*/
    }
}



rologinit(k)
int k;
{
UsrInit(k); 
}
