#include <stdio.h>

typedef int SHORT;	/* this defn is m/c dependent. It must be 16 bits */
typedef int LONG;	/* this defn is m/c dependent. It must be 32 bits */
typedef unsigned int BOOLEAN;

#define MEM_SPACE(x) mem_space
#define MEM_TBL(x)   mem_tbl
#define MEM_PTR(x)   mem_ptr

/* definition of constants */
#define FALSE		0
#define TRUE		!FALSE
#define NULLPTR		0L
#define DUMMY		-9999	
#define MAXINT		0x7FFFFFFF  /* machine dept, vax int = 4 bytes	*/
#define MAXNUM		0xFFFFFFFF  /* machine dept, vax int = 4 bytes	*/

#define MAXMEMSIZE	8000

#define palloc(TTT,Count,PPPtr) OsAlloc(PPPtr,(Count) * sizeof(TTT),TTT)

#define Free_Block(p,s) OsFree(p,s)
#define Free_Msg(p,s) OsFreeMsg(p,s)

#define Malloc_Block(ptr,size,C) ptr = (C *) OsAlloc(size)
#define Malloc_Msg(ptr,size,C) ptr = (C *) OsAllocMsg(size)

extern int *mem_space;
extern int mem_ptr;
extern int maxMem;
extern int mem_tbl[][4];

#define OsNewChareWithID(A,B,C,D,E,F,G) \
		OsNewChare1(A,B,C,D,E,F,G,TRUE,DUMMY)
#define OsNewChare(A,B,C,D,E,F) \
		OsNewChare1(A,B,C,D,E,F,NULLPTR,FALSE,DUMMY)

#define OsNewChareWithIDToPE(A,B,C,D,E,F,G,Z) \
		OsNewChare1(A,B,C,D,E,F,G,TRUE,Z)
#define OsNewChareToPE(A,B,C,D,E,F,Z) \
		OsNewChare1(A,B,C,D,E,F,NULLPTR,FALSE,Z)

typedef struct str_usr1 {
    int		*head;
    int		*tail;
    int		qLen;
    int		maxLen;
} USRQUEUE;

typedef struct str_usr2 {
    int		isLogic;
    int	       	remotePE;
    int		remoteCH;
    USRQUEUE	pendingMsg;
} CHAREID;
