/*
 * PCN Abstract Machine Emulator
 * Authors:     Arun Nanda    (07/17/91)
 *              Steve Tuecke  (Modifed for better integration with PCN)
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * usc.c	-  Microsecond clock package.
 *
 * The following machine-specific libraries need to be linked in
 * with the application using the USC functions:
 *
 *      encore        -lpp
 *      balance       -lseq
 *      symmetry      -lseq
 */

#ifndef _PCN_INCLUDE_USC_H
#define _PCN_INCLUDE_USC_H

typedef unsigned long usc_time_t;

extern usc_time_t	_p_usc_MD_rollover_val;
    
extern void		_p_usc_init();
extern usc_time_t	_p_usc_MD_clock();


#ifdef encore
#   define USC_PRIMITIVES_DEFINED 1
    extern unsigned *_p_usc_encore_timer;

#   define usc_clock()		((usc_time_t) *_p_usc_encore_timer)
#   define usc_rollover_val()	(_p_usc_MD_rollover_val)
#endif

    
#if defined(balance) || defined(symmetry)
#   define USC_PRIMITIVES_DEFINED 1
#   ifndef GETUSCLK
#       include <usclkc.h>
#   endif

#   define usc_clock()		((usc_time_t) getusclk())
#   define usc_rollover_val()	(_p_usc_MD_rollover_val)
#endif    

    
#if defined(tc2000) || defined(ipsc860) || defined(delta)
#   define USC_PRIMITIVES_DEFINED 1

#   define usc_clock()		_p_usc_MD_clock()
#   define usc_rollover_val()	(_p_usc_MD_rollover_val)
#endif


#ifdef PCN_USE_BSD_TIME
#   define USC_PRIMITIVES_DEFINED 1
#   define usc_clock()		_p_usc_MD_clock()
#   define usc_rollover_val()	(_p_usc_MD_rollover_val * 1000000 - 1)
#endif

#ifndef USC_PRIMITIVES_DEFINED    
#   define usc_clock()		0
#   define usc_rollover_val()	0
#endif    

#endif /* _PCN_INCLUDE_USC_H */
