/*
 * PCN Abstract Machine Emulator
 * Authors:     Steve Tuecke and Ian Foster
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sr_bsdipc.h  -  send/receive header using BSD Unix IPC (TCP sockets)
 */

#undef PARALLEL
#define PARALLEL

#undef ASYNC_MSG
#define ASYNC_MSG 0

#undef SR_BSDIPC
#define SR_BSDIPC

#undef LOCAL_PCN_PATH_ARG
#define LOCAL_PCN_PATH_ARG

/* maximum number of nodes */
#ifndef MAX_NODES
#define MAX_NODES	128
#endif

/* maximum number of streams */
#ifndef MAX_STREAMS
#define MAX_STREAMS	1024
#endif

/*
 * The last possible available stream id (stream message type).
 * MAX_STREAMS must be less than LAST_STREAM_MSG_TYPE
 */
#define LAST_STREAM_MSG_TYPE	 9999999

/*
 * The PCN message types
 */
#define MSG_CLOSE_STREAM	10000000
#define MSG_DEFINE		10000001
#define MSG_VALUE		10000002
#define MSG_READ		10000003
#define MSG_CANCEL		10000004
#define MSG_COLLECT		10000005
#define MSG_INITIATE_EXIT	10000006
#define MSG_EXIT		10000007
#define MSG_PARAMS		10000008
#define MSG_GAUGE		10000009
