/*
 * PCN Abstract Machine Emulator
 * Authors:     Steve Tuecke and Ian Foster
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * md_unix.c  -  Machine dependent file for Unix systems
 */

#include "pcn.h"

#include <signal.h>

#ifdef PDB_HOST
static FILE *keyboard_fp;
#endif


static void abort_handler(i)
int i;
{
    char buf[256];

#ifdef PDB
    if (i == SIGINT && !_pdb_query_to_abort())
    {
#ifdef iris	
	signal(SIGINT,  abort_handler);
#endif	
	return;
    }
#endif /* PDB */    
    
    sprintf(buf, "Aborting on signal %d", i);
    _p_fatal_error(buf);

    signal(i, SIG_DFL);
#if defined(PCN_SYSV)
    sigrelse(i);
#else  /* PCN_SYSV */    
    sigsetmask(0);
#endif /* PCN_SYSV */    
    kill(getpid(), i);
    exit(1);
} /* abort_handler() */


#ifndef PCN_SYSV3_2
static void stop_handler(i)
int i;
{
    if (i == SIGTSTP)
    {
	signal(SIGTSTP, SIG_DFL);
	kill(getpid(), SIGTSTP);
    }
    else	/* SIGCONT */
    {
	signal(SIGTSTP, stop_handler);
    }
} /* stop_handler() */
#endif /* PCN_SYSV3_2 */


/*
 * void _p_init_machine_dep()
 *
 * Initialize any machine dependencies.
 */
void _p_init_machine_dep()
{
#ifdef PDB_HOST    
    /* Set up for PDB keyboard input */
    keyboard_fp = stdin;
#endif /* PDB_HOST */

    if (!_p_no_signal_handlers)
    {
#ifndef PCN_SYSV3_2
	/*
	signal(SIGTSTP, stop_handler);
	signal(SIGCONT, stop_handler);
	*/
#endif /* PCN_SYSV3_2 */
	
	/* Set up the signal handlers for controlled crashes */
	signal(SIGQUIT, abort_handler);
	signal(SIGILL,  abort_handler);
	signal(SIGFPE,  abort_handler);
	signal(SIGBUS,  abort_handler);
	signal(SIGTERM, abort_handler);
	signal(SIGINT,  abort_handler);
#ifndef symmetry
	/* The Sequent machines use SEGV to deal with shared memory */
	signal(SIGSEGV, abort_handler);
#endif /* symmetry */    
    }
} /* _p_init_machine_dep() */


/*
 * void _p_shutdown_machine_dep()
 *
 * Shutdown any machine dependencies.
 */
void _p_shutdown_machine_dep()
{
} /* _p_shutdown_machine_dep() */


/*
 * void _p_abort_machine_dep()
 *
 * Shutdown any machine dependencies for an abortive exit.
 */
void _p_abort_machine_dep()
{
} /* _p_abort_machine_dep() */


#ifdef PDB_HOST
/*
 * char *_p_fgets(char *buf, int buf_len)
 *
 * This function implements a blocking read of a single
 * line of text from the keyboard (stdin normally).
 * It is used by PDB to get an input line.
 *
 * It reads n-1 characters, or up through a newline character,
 * whichever comes first, from the keyboard stream into the buffer
 * 'buf'.  The last character read into s is followed by a null
 * character.  (In other words, this function is like fgets()...)
 *
 * If EOF is encountered, then reset the keyboard_fp so that a
 * future read from it will not automatically return EOF.  In other
 * words, this routine should return EOF -- but after returning
 * EOF then it should go on as normal as if the EOF did not occur.
 *
 * Return:	NULL upon EOF, otherwise 'buf'.
 */
char *_p_fgets(buf, buf_len)
char *buf;
int buf_len;
{
    if (!_p_host)
    {
	return ((char *) NULL);
    }
    else
    {
	char *rc = fgets(buf, buf_len, keyboard_fp);
	if (rc == (char *) NULL)
            fseek(stdin, 2, 0L);	/* Reset keyboard_fp */
	return (rc);
    }
} /* _p_fgets() */

#endif /* PDB_HOST */
