#define DEFINE_GLOBALS

#include "co_parse.h"
#include "pcn_c_hdr.h"
#include "pcn_types.h"

#include <math.h>

void _p_co_set_backward_compatibility(val)
int_t *val;
{
    _p_co_backward_compatibility_flag = (int) *val;
}

void _p_co_init_parser(file_name, fp)
char_t *file_name;
FILE **fp;
{
#ifdef YYDEBUG
    extern int yydebug;

    yydebug = 0;
#endif
    _p_co_parse_tree = (datum *) NULL;

    _p_co_lineno = 0;
    strcpy(_p_co_filename, file_name);

    _p_co_parse_done_flag = 0;
    _p_co_parse_completely_done_flag = 0;

    _p_co_error_count = 0;

    _p_co_yyin = *fp;

    _p_co_l_temp_max = 0;
    _p_co_g_temp_max = 0;

    _p_co_allow_assignment_in_guard = 0;
}

void _p_co_parse_one_form(parse_tree_ptr, parse_had_errors, done_parsing)
datum **parse_tree_ptr;
int_t *parse_had_errors;
int_t *done_parsing;
{
    int save_error_count;
    int parser_ret;

    save_error_count = _p_co_error_count;
    
    _p_co_l_temp_max = 0;
    _p_co_push_token = 0;
    parser_ret = _p_co_yyparse();

    _p_co_clear_input();

    if (parser_ret != 0 || _p_co_error_count > save_error_count)
	*parse_had_errors = 1;
    else
	*parse_had_errors = 0;

    *done_parsing = _p_co_parse_completely_done_flag;

    *parse_tree_ptr = _p_co_parse_tree;
}

void _p_co_get_global_temp_max(count)
int_t *count;
{
    *count = _p_co_g_temp_max;
}

void _p_co_get_parse_error_count(count)
int_t *count;
{
    *count = _p_co_error_count;
}

void _p_co_print_parse_tree(tree)
datum **tree;
{
    _p_co_print(*tree);
}

void _p_co_free_parse_tree(parse_tree_ptr)
datum **parse_tree_ptr;
{
    _p_co_free(*parse_tree_ptr);
}

void _p_co_check_var_for_temp_max(var)
datum *var;
{
    char *s;
    int *counter, val;

    if (!D_IS_STRING(var))
    {
	fprintf(stderr,
		"Fatal Inconsistency: _p_co_check_var_for_temp_max() called with non-string\n");
	fprintf(stderr, "Datum type was %d\n", D_TYPE(var));
	exit(1);
    }

    s = D_SVAL(var);

    if (s[0] == '\0' || s[1] == '\0' || s[2] == '\0')
	return;

    if (s[0] == '_' && s[1] == 'l')
    {
	counter = &_p_co_l_temp_max;
    }
    else if (s[0] == '_' && s[1] == 'g')
    {
	counter = &_p_co_g_temp_max;
    }
    else
	return;

    val = 0;
    while (*s != '\0')
    {
	if (*s >= '0' && *s <= '9')
	    val = val * 10 + (*s - '0');
	s++;
    }


#if 0
    val = atoi(s + 2);
#endif
    
    if (val > *counter)
	*counter = val;
    return;
}

/*
 * Methods to return the parse tree to the PCN side.
 */

void _p_co_get_datum_type(term, type)
datum **term;
int_t *type;
{
    *type = (int_t) D_TYPE(*term);
}

void _p_co_get_int_datum(term, ival)
datum **term;
int_t *ival;
{
    *ival = (int_t) D_IVAL(*term);
}

void _p_co_get_double_datum(term, rval)
datum **term;
double_t *rval;
{
    *rval = (double_t) D_DVAL(*term);
}

void _p_co_get_string_len(term, len)
datum **term;
int_t *len;
{
    *len = (int_t) strlen(D_SVAL(*term));
}

void _p_co_get_string(term, string)
datum **term;
char_t *string;
{
    strcpy(string, D_SVAL(*term));
}

void _p_co_get_tag_datum(term, tagval)
datum **term;
int_t *tagval;
{
    *tagval = (int_t) D_IVAL(*term);
}

void _p_co_get_list_head_datum(term, head)
datum **term, **head;
{
    *head = D_LHEAD(*term);
}

void _p_co_get_tuple_len(term, len)
datum **term;
int_t *len;
{
    *len = (int_t) D_NARGS(*term);
}

void _p_co_get_tuple_arg(term, i, arg)
datum **term, **arg;
int_t *i;
{
    *arg = D_ARG(*term, (int_t) *i);
}

void _p_co_syntax_error(s)
char *s;
{
    
    fprintf(stderr,"%s:%d: %s\n", _p_co_filename, _p_co_lineno, s);
    _p_co_error_count++;
    if (_p_co_error_count > 100)
    {
	fprintf(stderr, "Too many errors, giving up\n");
	exit(1);
    }
}

void _p_co_warning(s)
char *s;
{
    
    fprintf(stderr,"%s:%d: Warning: %s\n", _p_co_filename, _p_co_lineno, s);
}
