/*
 * PCN System
 * Author:      Robert Olson
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * co_internal.h
 *
 */

#ifndef _PCN_INCLUDE_CO_INTERNAL_H
#define _PCN_INCLUDE_CO_INTERNAL_H

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/*
 * The 'params' tuple is passed around to everything and contains
 * parameters that define the specific actions of the run.  It is
 * just a tuple containing all of the parameters.  The
 * following macros can be used to access the various parameters
 * by name.
 */
#define params_out_file			params[0]
#define params_cpp_args			params[1]
#define params_trace_level		params[2]
#define params_vt_xforms		params[3]
#define params_lint_xforms		params[4]
#define params_user_xforms		params[5]
#define params_basic_xforms		params[6]
#define params_dump_list		params[7]
#define params_merge			params[8]
#define params_verbose			params[9]
#define params_read_stdin		params[10]
#define params_source_type		params[11]
   
#define PARAMS_TUPLE_SIZE		12
    
/*
 * Default values for the params
 */

#define DEFAULT_OUT_FILE 		""
#define DEFAULT_CPP_ARGS 		["-DPCN"]
#define DEFAULT_TRACE_LEVEL 		0
#define DEFAULT_VT_XFORMS 		1
#define DEFAULT_LINT_XFORMS 		1
#define DEFAULT_BASIC_XFORMS		1
#define DEFAULT_USER_XFORMS 		[]
#define DEFAULT_DUMP_LIST 		[]
#define DEFAULT_MERGE_FLAG		0
#define DEFAULT_VERBOSE_FLAG		0
#define DEFAULT_READ_STDIN_FLAG		0
#define DEFAULT_SOURCE_TYPE		"pcn"
    
#endif /* _PCN_INCLUDE_CO_INTERNAL_H */
