/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Xsw/RCS/DirP.h,v 1.1 1992/04/17 18:24:45 mei Exp $
 *
 * Private declarations for DirWidgetClass
 */

/******************************************************************************
*									      *
*	Copyright (C) The Aerospace Corporation 1991			      *
*									      *
*	This software was developed by The Aerospace Corporation as a 	      *
*	research endeavor for the United States Air Force 		      *
*	Space Systems Division.  The current version of the Gauge	      *
*	computer program is available for  release to you for		      *
*	educational and research purposes only.  It is not 		      *
*	to be used for commercial purposes.				      *
*									      *
*	In addition, the following conditions shall apply.		      *
*									      *
*	1) The computer software and documentation were designed to	      *
*	satisfy internal Aerospace requirements only.			      *
*	The software is provided ``as is,'' and The Aerospace Corporation     *
*	makes no warranty, expressed or implied, as to it accuracy,	      *
*	functioning, or fitness for a particular purpose.		      *
*									      *
*	2) The Aerospace Corporation and its personnel are not		      *
*	responsible for providing technical support or general assistance     *
*	with respect to the software.					      *
*									      *
*	3) Neither The Aerospace Corporation nor its personnel shall be	      *
*	liable for claims, losses, or damages arising out of or connected     *
*	with the use of this software.					      *
*	Your sole and exclusive remedy shall be to request a replacement      *
*	copy of the program.						      *
*									      *
******************************************************************************/

#ifndef _DirP_h
#define _DirP_h

#include "Dir.h"
#include <X11/Xaw/FormP.h>

typedef struct {int empty;} DirClassPart;

typedef struct _DirClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    DirClassPart	dir_class;
} DirClassRec;

extern DirClassRec dirClassRec;

typedef struct _DirPart {
  /* resources */
  XtCallbackList directory_change;
  XtCallbackList user_directory;
  Boolean show_dot_files;
  Boolean show_directories;
  Boolean show_backup_files;
  Boolean full_path;
  SType select_type;
  String current_dir;
  SCPairList extensions;
  int interval;

  /* private */
  XtIntervalId timer_proc_id;
  time_t mod_time;
  
  StringList return_list;
  StringList file_list;
  StringList legal_extensions;
  String cur_selection;
  Boolean pending_error;
  Widget label_w;
  Widget viewer_w;
  Widget list_w;
} DirPart;


typedef struct _DirRec {
    CorePart	core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    DirPart	dir;
} DirRec;


typedef struct {
    /* resources */
  int dummy;
} DirConstraintsPart;

typedef struct _DirConstraintsRec {
    FormConstraintsPart	form;
    DirConstraintsPart	dir;
} DirConstraintsRec, *DirConstraints;

#endif /* _DirP_h */
