
/********************************************************/
/* File :  */
/* Content : routines for allocating different arrays   */
/*   of size=snap_cnt after the snapshot count is known */
/* Date : 1/1992                                        */
/********************************************************/
#include <stdio.h>

#ifdef HISTOGRAM
#include <Xsw/Xsw.h>
#include <Gauge/Gauge.h>
#endif

#ifndef _MODEL_H
#include "model.h"
#endif

ProcedureProfileData *init_a_total();
void init_snapname_list();
void init_proc_total();
void init_node_total();

void init_all_snapFixArrays(hPtr)
Histo *hPtr;
{
int snap_cnt = hPtr->info.snap_cnt;

init_snapname_list(hPtr,snap_cnt);
map_table(hPtr->modules,init_snaptable,(char *)&snap_cnt);
init_proc_total(hPtr);
init_node_total(hPtr);
}

/********************************************************/
/* for Histo's snapname list                            */
/********************************************************/

void init_snapname_list(hPtr,snap_cnt)
Histo *hPtr;
int snap_cnt;
{
hPtr->info.snap = (SnapName *)
   checkmalloc(sizeof(SnapName)*snap_cnt,"read_counters");
}

int get_snaptotal(hPtr)
Histo *hPtr;
{
   return(hPtr->info.snap_cnt);
}

char *get_snapname(hPtr,snap_no)
Histo *hPtr;
int snap_no;
{
    return((char *) hPtr->info.snap[snap_no].name);
}
	
/********************************************************/
/* for Procedure's total                                */
/********************************************************/

void init_proc_total(hPtr)
Histo *hPtr;
{
int snap_cnt=hPtr->info.snap_cnt;

map_procedures(hPtr->modules,init_a_proc_total,(char *)&snap_cnt);

}

/*ARGSUSED*/
char *init_a_proc_total(proc_name,pPtr,snap_cnt)
char *proc_name;
Procedure *pPtr;
int *snap_cnt;
{
int cnt= *snap_cnt;

pPtr->total = init_a_total(cnt);
return (char *) snap_cnt;
}


/********************************************************/
/* for Node's total                                     */
/********************************************************/

void init_node_total(hPtr)
Histo *hPtr;
{
int i;
int node_cnt=hPtr->info.node_cnt;
int snap_cnt=hPtr->info.snap_cnt;
Node *nPtr;

for(i=0;i<node_cnt;i++) {
    nPtr=hPtr->nodes+i;
    nPtr->total = init_a_total(snap_cnt);
}/*for*/
}


ProcedureProfileData *init_a_total(snap_cnt)
int snap_cnt;
{
int i;
static ProcedureProfileData *Ptr;
ProcedureProfileData *tPtr;

Ptr=(ProcedureProfileData *)
  checkmalloc(sizeof(ProcedureProfileData)*snap_cnt,
	      "init_a_node_total");
for(i=0;i<snap_cnt;i++) {
  tPtr=Ptr+i;
  tPtr->snap_no=i;
  tPtr->counts.use = tPtr->counts.failure = 
     tPtr->counts.commit = tPtr->counts.suspend = 0; 
  tPtr->cost.success = tPtr->cost.failure = 
     tPtr->cost.suspend = tPtr->cost.total = 0; 
}/*for*/

return Ptr;
}


/********************************************************/
/* for Module's snaptable                               */
/********************************************************/

char *init_snaptable(mod_name,mPtr,snap_cnt)
char *mod_name;
Module *mPtr;
int *snap_cnt;
{
int i;
int cnt= *snap_cnt;

if(mPtr->snaptable != (TableHeader *) NULL) {
  sprintf(TextBuffer,"Module[%s]'s snaptable has \
    been initialized",mod_name);
  GaugeError("init_snaptable",TextBuffer);
  }else {
  mPtr->snaptable = (TableHeader *)
    checkmalloc(sizeof(TableHeader)*cnt,"init_snaptable");
  for(i=0;i<cnt;i++)
       mPtr->snaptable[i].tbl_cnt=0;
}/*if*/
return (char *)snap_cnt;

}

