/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/ViewerP.h,v 1.5 1992/04/17 18:18:12 mei Exp $
 * Private declarations for ViewerWidgetClass
 */

/* AERO_MESG */

#ifndef _ViewerP_h
#define _ViewerP_h

#include "Viewer.h"
#include <X11/Xaw/FormP.h>

typedef struct {
  Widget dummy, colors, scale, box, popbar, rbar;
  double *cell;
  Boolean *state;
  Boolean up;
} ColorCode;

typedef struct {int empty;} ViewerClassPart;

typedef struct _ViewerClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    FormClassPart	form_class;
    ViewerClassPart	viewer_class;
} ViewerClassRec;

extern ViewerClassRec viewerClassRec;

typedef struct _ViewerPart {
  /* resources */
  XtCallbackList view_change_callback;
  int  cell_height,        /* the width and height of each cell */
       cell_width;         /* in the chart_w */
  Dimension height, width; /* height and width in cells of chart_w */
  Boolean log;             /* true if log_scale should be used */
  Boolean zoom;            /* true if zoom mode active */
  Boolean bucket;          /* true if bucketing should be done */
  ListElement * hlist;     /* the list of nodes */
  ListElement * vlist;     /* the list of procedures */
  int           zptr;      /* the current snapshot number hui2/24 */
  VType show_type;         /* the type of view to show */  
  VTypeList root_type;     /* the root type of this view */  
  StringList data;         /* index to get_value for data type */
  String text;             /* contents of text_w */
  double (*get_value)();   /* function to return value of a position */
  Widget radio_view;

  /* private state */
  View return_view;
  ColorCode   color_code;
  ListElement * blist;    /* the list of buckets */
  int n_buckets;          /* the number of buckets */
  int n_views;            /* the number of data types currently shown */

  Boolean * state;        /* Holds the selection status of cells */
  double * cell;          /* pointer to cell array used for displaying
                             the chart bitmap  */
  double * masterval;     /* pointer to the values corresponding to
                             the mastercell array */

  double maximum,         /* max and min of the cell array */
         minimum, 
         sum;
  double savemaximum,     /* save max and min for future resetting */ 
         saveminimum;
  double calcmaximum,     /* the actual max and min used for */
         calcminimum;     /* calculating the percentage */
  String title;            /* the title of the current view */
  Dimension title_height;  /* the height of the current title */
  Widget chart_w;
  Widget hlist_w, scale_w, vlist_w;
  Widget dummy_w;
  Widget hscroll_w, vscroll_w; 
  Widget title_w, text_w;
} ViewerPart;

typedef struct BucketStruct Bucket;

typedef struct BucketStruct {
  void * vPtr;
  void * hPtr;
  Bucket * next;
}BucketRec;


typedef struct _ViewerRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    ViewerPart		viewer;
} ViewerRec;


typedef struct {
    /* resources */

    /* private state */
    Boolean  reparented; /* True if child has been re-parented */
} ViewerConstraintsPart;

typedef struct _ViewerConstraintsRec {
    FormConstraintsPart		form;
    ViewerConstraintsPart	viewer;
} ViewerConstraintsRec, *ViewerConstraints;

#endif /* _ViewerP_h */
