/*
 * $Header: /ufs/comp/mei/PROJ_PCN/onprofile/IFModel/Model/Gauge/RCS/Viewer.h,v 1.3 1992/04/17 18:18:01 mei Exp $
 * Public definitions for Viewer widget
 */

/* AERO_MESG */

#ifndef _Viewer_h
#define _Viewer_h

#include <X11/Xaw/Form.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 bucket              Bucket              Boolean         False
 cellHeight          CellSize            int             16
 cellWidth           CellSize            int             16
 data                Data                String          NULL
 getValueFunction    GetValueFunction    double *()      NULL
 heightInCells       NumberCells         int             20
 hlist               List                ListElement *   NULL
 log                 Log                 Boolean         False
 radioView           RadioView           Widget          NULL
 rootType            rootType            VType           ThreeD
 showType            showType            VType           ThreeD
 text                Text                String          NULL
 viewTitle           ViewTitle           String          NULL
 viewChange          Callback            XtCallbackRec   NULL
 vlist               List                ListElement *   NULL
 widthInCells        NumberCells         int             20
 zoom                Zoom                Boolean         False
 zptr                Zptr                int             0
 
*/

/* fields added to Form */
#define XtNbucket               "bucket"
#define XtNcellHeight           "cellHeight"
#define XtNcellWidth            "cellWidth"
#define XtNdata                 "data"
#define XtNgetValueFunction     "getValueFunction"
#define XtNheightInCells        "heightInCells"
#define XtNhlist                "hlist"
#define XtNlog                  "log"
#define XtNradioView            "radioView"
#define XtNrootType             "rootType"
#define XtNshowType             "showType"
#define XtNtext                 "text"
#define XtNviewTitle            "viewTitle"
#define XtNviewChange           "viewChange"
#define XtNvlist                "vlist"
#define XtNwidthInCells         "widthInCells"
#define XtNzoom                 "zoom"
#define XtNzptr                 "zptr"

#define XtCBucket               "Bucket"
#define XtCCellSize             "CellSize"
#define XtCData                 "Data"
#define XtCGetValueFunction     "GetValueFunction"
#define XtCList                 "List"
#define XtCLog                  "Log"
#define XtCNumberCells          "NumberCells"
#define XtCRadioView            "RadioView"
#define XtCViewTitle            "ViewTitle"
#define XtCText                 "Text"
#define XtCType                 "Type"
#define XtCZoom                 "Zoom"
#define XtCZptr                 "Zptr"

#define ByNodes 0
#define ByProcedures 1
#define ThreeD 2
#define Bucket3D 6

#define XtRVType   "VType"
typedef int VType;
#define XtRVTypeList   "VTypeList"
typedef VType * VTypeList;

typedef int MType;
#define OR 6
#define AND 12

typedef struct {
  VType type;
  StringList data;
} View;

extern WidgetClass viewerWidgetClass;

typedef struct _ViewerClassRec *ViewerWidgetClass;
typedef struct _ViewerRec  *ViewerWidget;


/******************************************************************
 *
 * Exported Functions
 *
 *****************************************************************/
extern Widget XswViewerChartWidget(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);

/*      Function Name: ClearSelections.
 *      Description: Deselects all items in viewer widget.
 *      Arguments: w - the viewer widget.
 *      Returns: none.
 */
extern void XswViewerClearSelections(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);


/*      Function Name: XswViewerMapSelections.
 *      Description: Calls a user defined function once for each 
 *                   selected item in viewer.
 *      Arguments: w - the viewer widget.
 *                 f - the user-defined function.
 *                 d - a void pointer that is passed to f on each call
 *      Returns: none.
 *      Comments: f should be defined as 
 *                void f(vPtr, hPtr, data, d)
 *                   vPtr - the pointer field of the vlist for the row
 *                          of the selected item.
 *                   hPtr - the pointer field of the hlist for the col
 *                          of the selected item.
 *                   data - the data field of the viewer widget.
 *                   d    - an arbitrary void pointer intended for
 *                          the accumulation of data.
 */
extern void XswViewerMapSelections(
#if NeedFunctionPrototypes
     Widget          /* w */,
     void (*)()      /* (*f)() */,
     void *          /* d */
#endif
);

extern void XswViewerMapSelectedRows(
#if NeedFunctionPrototypes
     Widget          /* w */,
     void (*)()      /* (*f)() */,
     void *          /* d */
#endif
);


/*      Function Name: XswViewerColumnValue.
 *      Description: Returns the value of a column in the viewer.
 *      Arguments: w - the viewer widget.
 *                 list - ListElement pointer.
 *      Returns: the sum of all selected nodes in the column given
 *               by list.  If no nodes are selected then all nodes
 *               in the column will be summed over.
 */

extern double XswViewerColumnValue(
#if NeedFunctionPrototypesOFF
     Widget          /* w */,
     ListElement *   /* list */
#endif
);


/*      Function Name: XswViewerSelectedColumns.
 *      Description: Returns the value of a column in the viewer.
 *      Arguments: w - the viewer widget.
 *                 vPtr - a pointer to a vector of Booleans.
 *                 nPtr - a pointer to an integer to be set to the
 *                        number of entry in the vector.
 *      Returns: none.
 */
extern int XswViewerSelectedColumns(
#if NeedFunctionPrototypes
     Widget          /* w */,
     MType           /* mode */,
     Boolean **      /* vPtr */,
     int     *       /* nPtr */
#endif
);


/*      Function Name: XswViewerSelectedRows.
 *      Description: Returns the value of a row in the viewer.
 *      Arguments: w - the viewer widget.
 *                 vPtr - a pointer to a vector of Booleans.
 *                 nPtr - a pointer to an integer to be set to the
 *                        number of entry in the vector.
 *      Returns: none.
 */
extern int XswViewerSelectedRows(
#if NeedFunctionPrototypes
     Widget          /* w */,
     MType           /* mode */,
     Boolean **      /* vPtr */,
     int     *       /* nPtr */
#endif
);


/*      Function Name: XswViewerRowValue.
 *      Description: Returns the value of a row in the viewer.
 *      Arguments: w - the viewer widget.
 *                 list - ListElement pointer.
 *      Returns: the sum of all selected nodes in the row given
 *               by list.  If no nodes are selected then all nodes
 *               in the row will be summed over.
 */
extern double XswViewerRowValue(
#if NeedFunctionPrototypesOFF
     Widget          /* w */,
     ListElement *   /* list */
#endif
);

/*      Function Name: XswViewerBucketValue.
 *      Description: Returns the value of a row in the viewer if that
 *		     row is from a bucketed histogram.
 *      Arguments: w - the viewer widget.
 *                 list - Bucket pointer.
 *      Returns: the value of the bucket bar.
 */
extern double XswViewerBucketValue(
#if NeedFunctionPrototypesOFF
     Widget          /* w */,
     ListElement *   /* list */
#endif
);


/*      Function Name: XswViewerUpdateView.
 *      Description: Forces a redisplay of the viewer widget.
 *      Arguments: w - the viewer widget.
 *      Returns: none.
 */
extern void XswViewerUpdateView(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);


/*      Function Name: XswViewerGetBounds.
 *      Description: Gets maximum and minimum values in chart.
 *      Arguments: w - the viewer widget.
 *                 maxPtr - where to write the maximum value.
 *                 minPtr - where to write the minimum value.
 *      Returns: none.
 */
extern void XswViewerGetBounds(
#if NeedFunctionPrototypes
     ViewerWidget    /* w */,
     double *        /* maxPtr */,
     double *        /* minPtr */
#endif
);


/*      Function Name: XswViewerPopupScale.
 *      Description: Pops up a scale showing value of colors in 3D.
 *      Arguments: w - the viewer widget.
 *      Returns: none.
 */
extern void XswViewerPopupScale(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);


/*      Function Name: XswViewerSetText.
 *      Description: Set string to display in text area.
 *      Arguments: w - the viewer widget.
 *                 text - the string to display.
 *      Returns: none.
 */
extern void XswViewerSetText(
#if NeedFunctionPrototypes
     Widget          /* w */,
     String          /* text */
#endif
);


/*      Function Name: XswViewerGetZptr 
 *      Description: Show which snapshot is currently being used. 
 *      Arguments: w - the viewer widget.
 *                 zptr - the returned zptr (snapshot) value.
 *      Returns: none.
 */
extern void XswViewerGetZptr(
#if NeedFunctionPrototypes
     Widget          /* w */,
     int *           /* zptr */
#endif
);


/*      Function Name: XswViewerSetZptr 
 *      Description: Set the new snapshot for the viewer. 
 *      Arguments: w - the viewer widget.
 *                 zptr - the new zptr (snapshot) value.
 *      Returns: none.
 */
extern void XswViewerSetZptr(
#if NeedFunctionPrototypes
     Widget          /* w */,
     int             /* zptr */
#endif
);


/*      Function Name: XswViewerDisableViewUpdate
 *      Function Name: XswViewerEnableViewUpdate
 *      Description: Enable and Disable the Chart_w's update through
 *                   the setting and resetting of in_make_chart
 *      Arguments: none.
 *      Returns: none.
 */
extern void XswViewerDisableViewUpdate();
extern void XswViewerEnableViewUpdate();


/*      Function Name: XswViewerIsBucket
 *      Description: Return the value of current bucket state.
 *      Arguments: w - the viewer widget.
 *      Returns: Boolean.
 */
extern Boolean XswViewerIsBucket(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);


/*      Function Name: XswViewerViewType
 *      Description: Return the current view type.
 *      Arguments: w - the viewer widget.
 *      Returns: VType
 */
extern VType XswViewerViewType(
#if NeedFunctionPrototypes
     Widget    /* w */
#endif
);


#endif /* _Viewer_h */
