
/********************************************************/
/* File: Range.h                                        */
/* Content: Public include file for Range Widget        */
/* Date: 3/1992                                         */
/********************************************************/

#ifndef _XawRange_h
#define _XawRange_h

#include <X11/Xaw/Form.h>

/********************************************************
Resources:

Name		  Class         RepType		Default Value
----		  -----		-------		-------------
destroyCallback   Callback      Pointer	        NULL 
setRange          Callback      Pointer         NULL
resetRange        Callback      Pointer         NULL
clearSetRange     Callback      Pointer         NULL
popDownRange      Callback      Pointer         NULL
barHeight         BarHeight     Dimension       10    
barBlocks         BarBlocks     Dimension       1
sensitive         Sensitive	Boolean	        True
width             Width         Dimension       0
setRange          Callback      XtCallbackRec   NULL
stateArray        StateArray    Boolean *       NULL
cellArray         CellArray     double *        NULL
palette           Palette       String          NULL
calcMax           CalcMax       double          100
calcMin           CalcMin       double          0
saveMax           SaveMax       double          100
saveMin           SaveMin       double          0
isLog             IsLog         Boolean         True
********************************************************/
/* Class record constants */

#define XtCTopBound     "TopBound"
#define XtCBottomBound  "BottomBound"
#define XtCBarHeight    "BarHeight"
#define XtCBarBlocks    "BarBlocks"
#define XtCCellArray    "CellArray"
#define XtCStateArray   "StateArray"
#define XtCPalette      "Palette"
#define XtCCalcMax      "CalcMax"
#define XtCCalcMin      "CalcMin"
#define XtCSaveMax      "SaveMax"
#define XtCSaveMin      "SaveMin"
#define XtCIsLog        "IsLog"

#define XtNtopBound       "topBound"
#define XtNbottomBound    "bottomBound"
#define XtNbarHeight      "barHeight"
#define XtNbarBlocks      "barBlocks"
#define XtNsetRange       "setRange"
#define XtNclearSetRange  "clearSetRange"
#define XtNresetRange     "resetRange"
#define XtNpopDownRange   "popDownRange"
#define XtNcellArray      "cellArray"
#define XtNstateArray     "stateArray"
#define XtNpalette        "palette"
#define XtNcalcMax        "calcMax"
#define XtNcalcMin        "calcMin"
#define XtNsaveMax        "saveMax"
#define XtNsaveMin        "saveMin"
#define XtNisLog          "isLog"

extern WidgetClass rangeWidgetClass;

typedef struct _RangeClassRec *RangeWidgetClass;
typedef struct _RangeRec      *RangeWidget;


/*****************************************************************
*                                                                *
*    exported  functions                                         *
*                                                                *
*****************************************************************/

/*      Function Name: XswRangeReset
 *      Description: to return the Range Selection window to the
 *                   initial state.
 *      Arguments: rw - the range widget. 
 *                 client_data, call_data - 
 *      Returns: none.
 */
extern void XswRangeReset(
#if NeedFunctionPrototypesOFF
    RangeWidget    /* rw */, 
    XtPointer      /* client_data */,
    XtPointer      /* call_data */
#endif
);


/*      Function Name: XswRangeGetNew
 *      Description: retrieve the range to be used as boundary
 *                   for selecting which cell in the view to keep.
 *      Arguments: rw - the range widget 
 *                 max, min - the new range boundary
 *      Returns: none.
 */
extern void XswRangeGetNew(
#if NeedFunctionPrototypes
    RangeWidget   /* rw */, 
    double *      /* max */,
    double *      /* min */
#endif
);


#endif /* _XawRange_h */
/* DON' TADD STUFF AFTER THIS #endif */
