/****************************************************************
Copyright (C) The University of Melbourne 1993
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of The University of Melbourne 
or any of its entities not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.

THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
	  Andrew Davison (ad@cs.mu.oz.au)

COMMENTS : Just free all memory associated with the tree
****************************************************************/

/* Include all the header files needed */
#include "bebop.h"
#include "y.tab.h"

/* Prototype declaration */
void free_list(TLISTPTR flist);

/* Free_tree : given a pointer (root) of a tree the function just
   free's all memory associated with the tree
*/
void free_tree(TREEPTR root)
{
	int op;

	if (root)
	{
		op = OP(root);
		if (op < 0)
		{
			
			free_tree(OP1(root));
			free_tree(OP2(root));
			free(root);
			root = NULL;
			return;
		}

		if (op >= TOK_CUT && op <= TOK_PIPE)
		{
			free_tree(OP1(root));
			free_tree(OP2(root));
			free(root);
			root = NULL;
			return;
		}

		if (op < TOK_START_TABLE )
		{
			if (op == TOK_VAR)
			{
				free(root);
				root = NULL;
				return;
			}

			if (op == TOK_ATOM)
			{
				free_tree(PREDT(root).args);
				PREDT(root).args = NULL;
				free(root);
				root = NULL;
				return;
			}

			CONSTT(root) = NULL;
			free(root);
			root = NULL;
			return;
		}

		if (op > TOK_START_TABLE && op < TOK_END_TABLE)
		{
			free_tree(OP1(root));
			free_tree(OP2(root));
			free(root);
			root = NULL;
			return;
		}

		if (op == TOK_CLAUSES || op == TOK_PNU || op == TOK_NU || op == TOK_DBS)
		{
			free_list(LIST(root));
			free(root);
			root = NULL;
			return;
		}

		free_tree(OP1(root));
		free_tree(OP2(root));
		free(root);
		root = NULL;
		return;
	}

	return;
}

/* Free_list : given a list of trees just free's all memory associated
   with the list of trees
*/
void free_list(TLISTPTR flist)
{
	TLISTPTR list, list2;

	list = flist;

	while(list)
	{
		free_tree(list->tree);
		list2 = list;
		list = list->next;
		free(list2);
	}
	return;
}
