/* $Id: time.c,v 1.9 1993/07/05 13:31:10 bd Exp $  */ 
#include "sysdeps.h"

#ifdef unix
#include <sys/time.h>
#include <sys/resource.h>

#include "c.h"

#ifndef HAS_NO_GETRUSAGE

extern int getrusage PROTO((int who, struct *rusage));

struct rusage u;

int systime() {
  getrusage(RUSAGE_SELF,&u);
  return u.ru_utime.tv_sec*1000 + u.ru_utime.tv_usec / 1000;
}

#else
/* Define or fake the systime() function here.
 * If we are running under UNIX System 5, we can do it with clock().
 */
#ifdef SYS5

int systime() {
  /* [BD] This gives user+sys time, not quite the same as ru_utime above. */
  return (int)(clock()/(CLOCKS_PER_SEC/1000));
}

#endif
#endif
#endif
