/* $Id: error.h,v 1.6 1993/10/06 11:39:00 bd Exp $
 */

#define FatalError(String)\
    { fprintf(stderr,"{FatalError: %s}\n",String);\
      error_exit(1); }


#define Error(String)\
    fprintf(stderr,"{Error: %s}\n",String);


/*
 * The error reporting macros may assume the existance
 * of a variable exs in their environment.
 *
 */

/* #define SERIOUS_FAULT(X)
 * #define INTERNAL_FAULT(X)
 */

#define MINOR_FAULT(Arg) {return FALSE;}

#define WARNING(String) { \
    fprintf(stderr,"{ WARNING: %s }\n", (String)); \
  }

#define USAGE_FAULT(String) { \
    fprintf(stderr,"{ USAGE FAULT: %s }\n", (String)); \
    return FALSE; \
  }

#define EXCEPTION(Term, Arg) {(Term) = make_exception_term((Arg), exs->andb);}

#define ERRNO make_errno_term(exs->andb)


enum errortypes {
    E_PUT_ARG,
    E_FILE_SPEC,
    E_OPEN_FILE,
    E_NR_FILES,
    E_ILLEGAL_GOAL,
    E_PRED_NOT_DEF
};

extern void error_exit();
extern void akl_error();
    
extern Term make_exception_term();
extern Term make_errno_term();

extern void initialize_error();
