/* $Id: compare.c,v 1.16 1993/10/05 17:56:04 boortz Exp $ */

#include <errno.h>
#include <string.h>
#include "include.h"
#include "term.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "unify.h"
#include "initial.h"
#include "storage.h"
#include "config.h"
#include "names.h"

typedef enum {
  CMP_LESS,
  CMP_EQUAL,
  CMP_GREATER
} compres_val;

static Term compres_atom[3];
static Functor functor_cons;

/* int, big, rat, flt, atm, fun, arity + lexical */

bool akl_compare_aux(); /* (Term, Term, exstate, compres_val *); */

bool akl_compare(Arg)
     Argdecl;
{
  register Term X0;
  bool res;
  compres_val compres;

  res = akl_compare_aux(A(1), A(2), exs, &compres);

  if (res == TRUE) {
    Deref(X0, A(0));
    return unify(X0, compres_atom[compres], exs->andb, exs);
  }
  else
    return res;
}

bool akl_compare_aux(x0, x1, exs, compres)
     Term x0, x1;
     exstate *exs;
     compres_val *compres;
{
  Term X0, X1;
  bool res;

  Deref(X0, x0);
  IfVarSuspend(X0);

  Deref(X1, x1);
  IfVarSuspend(X1);

  if (IsINT(X0)) {
    if (IsINT(X1)) {
      if (IntVal(Int(X0)) == IntVal(Int(X1)))
	*compres = CMP_EQUAL;
      else if (IntVal(Int(X0)) < IntVal(Int(X1)))
	*compres = CMP_LESS;
      else
	*compres = CMP_GREATER;
    }
    else if (IsFLT(X1))
      *compres = CMP_GREATER;
    else if (IsATM(X1) || IsLST(X1) || IsSTR(X1))
      *compres = CMP_LESS;
    else
      return FALSE;
  }
  else if (IsFLT(X0)) {
    if (IsFLT(X1)) {
      if (FltVal(Flt(X0)) == FltVal(Flt(X1)))
	*compres = CMP_EQUAL;
      else if (FltVal(Flt(X0)) < FltVal(Flt(X1)))
	*compres = CMP_LESS;
      else
	*compres = CMP_GREATER;
    }
    else {
      if (IsINT(X1) || IsATM(X1) || IsLST(X1) || IsSTR(X1))
	*compres = CMP_LESS;
      else
	return FALSE;
    }
  }
  else if (IsATM(X0)) {
    if (IsATM(X1)) {
      if (Eq(X0,X1))
	*compres = CMP_EQUAL;
      else {
	int strcmpval = strcmp(AtmPname(Atm(X0)), AtmPname(Atm(X1)));
	if (strcmpval > 0)
	  *compres = CMP_GREATER;
	else
	  *compres = CMP_LESS;
      }
    }
    else {
      if (IsINT(X1) || IsFLT(X1))
	*compres = CMP_GREATER;
      else if (IsLST(X1) || IsSTR(X1))
	*compres = CMP_LESS;
      else
	return FALSE;
    }
  }
  else if (IsLST(X0) || IsSTR(X0)) {
    if (IsLST(X0) && IsLST(X1)) {
      Term temp0, temp1;
      GetLstCar(temp0,Lst(X0));
      GetLstCar(temp1,Lst(X1));
      res = akl_compare_aux(temp0, temp1, exs, compres);
      if (res != TRUE)
	return res;
      else if (*compres == CMP_EQUAL) {
	GetLstCdr(temp0,Lst(X0));
	GetLstCdr(temp1,Lst(X1));
	return akl_compare_aux(temp0, temp1, exs, compres);
      }
      else
	return TRUE;
    }
    else if (IsSTR(X0) && IsSTR(X1) &&
	      (StrFunctor(Str(X0)) == StrFunctor(Str(X1)))) {
      int i;
      Term temp0, temp1;

      for (i = 0; i < StrArity(Str(X0)); i++) {
	GetStrArg(temp0,Str(X0),i);
	GetStrArg(temp1,Str(X1),i);
	res = akl_compare_aux(temp0, temp1, exs, compres);
	if (res != TRUE)
	  return res;
	else if (*compres != CMP_EQUAL)
	  return TRUE;
      }
      return TRUE;
    }
    else if (IsLST(X1) || IsSTR(X1)) {
      char *name0, *name1;
      int arity0, arity1;
      int cmp;

      if (IsLST(X0)) {
	name0 = ".";
	arity0 = 2;
      }
      else {
	name0 = StrPname(Str(X0));
	arity0 = StrArity(Str(X0));
      }

      if (IsLST(X1)) {
	name1 = ".";
	arity1 = 2;
      }
      else {
	name1 = StrPname(Str(X1));
	arity1 = StrArity(Str(X1));
      }

      if ((cmp = strcmp(name0, name1)) == 0) {
	if (arity0 < arity1)
	  *compres = CMP_LESS;
	else
	  *compres = CMP_GREATER;
      }
      else if (cmp < 0)
	*compres = CMP_LESS;
      else
	*compres = CMP_GREATER;
    }
    else if (IsINT(X1) || IsFLT(X1) || IsATM(X1))
      *compres = CMP_GREATER;
    else
      return FALSE;
  }
  else
    return FALSE;

  return TRUE;
}

#define CompareTerm(Name, Test) \
bool Name(Arg) \
     Argdecl; \
{ \
  compres_val compres; \
  bool res; \
 \
  res = akl_compare_aux(A(0), A(1), exs, &compres); \
  if(res == TRUE) { \
    if(Test) return TRUE; \
    else return FALSE; \
  } \
  else \
    return res; \
}
    
CompareTerm(akl_term_equal, compres == CMP_EQUAL)
CompareTerm(akl_term_not_equal, compres != CMP_EQUAL)
CompareTerm(akl_term_less, compres == CMP_LESS)
CompareTerm(akl_term_less_equal, compres != CMP_GREATER)
CompareTerm(akl_term_greater, compres == CMP_GREATER)
CompareTerm(akl_term_greater_equal, compres != CMP_LESS)

void initialize_compare() {

  functor_cons = store_functor(store_atom("."),2);

  compres_atom[CMP_LESS] = TagAtm(store_atom("<"));
  compres_atom[CMP_EQUAL] = TagAtm(store_atom("="));
  compres_atom[CMP_GREATER] = TagAtm(store_atom(">"));

  define("compare", akl_compare, 3);

  define("@<", akl_term_less, 2);
  define("@=<", akl_term_less_equal, 2);
  define("@>", akl_term_greater, 2);
  define("@>=", akl_term_greater_equal, 2);
  define("==", akl_term_equal, 2);
  define("\\==", akl_term_not_equal, 2);
}
