SPEC SCHACH = 
   FOLD + LISTOPS + READWRITE +

SORTS

zug     ::= oben | unten | links | rechts | d zug zug.
pos     ::= p integer integer.
farbe   ::= schwarz | weiss | leer.
figur   ::= (farbe -> pos -> brett -> bretter).
stein   ::= s f::farbe fig::figur.
brett   ::= (pos -> stein).
bretter ::= [brett].
figuren ::= [figur].

OPNS

auf_brett :: pos -> boolean.

EQNS

auf_brett (p X Y) = (1 <= X) && (X <= 8) && (1 <= Y) && (Y <= 8).

OPNS

andere      :: farbe -> farbe.
naechste    :: pos -> zug -> pos.
bewege      :: pos -> pos -> brett -> brett.
ein_schritt :: zug -> figur.
in_richtung :: zug -> figur.

EQNS

andere schwarz = weiss.
andere weiss   = schwarz.
andere leer    = leer.

naechste (p X Y) oben   = p X (Y+1).
naechste (p X Y) unten  = p X (Y-1).
naechste (p X Y) links  = p (X-1) Y.
naechste (p X Y) rechts = p (X+1) Y.
naechste P (d Z1 Z2) = naechste (naechste P Z1) Z2.

bewege P0 P1 B P =
  if P == P0
  then leer
  elsif P == P1
  then B P0
  else B P.

MACROS #P1 = naechste P Z.
      #F1 = f ((B #P1)::stein).
      #B1 = bewege P #P1 B.
      #OK = auf_brett #P1.
      
EQNS

ein_schritt Z F P B =
  if #OK && ((#F1 == leer) || (#F1 == andere F))
  then [#B1] 
  else [].
    
in_richtung Z F P B =
  if #OK && (#F1 == leer)
  then [#B1|in_richtung Z F #P1 #B1]
  elsif #OK && (#F1 == andere F)
  then [#B1]  
  else [].

OPNS
    
leer       :: stein.
g          :: farbe -> pos -> brett -> figur -> bretter -> bretter.
kombiniere :: figuren -> figur. 

EQNS

leer = s leer keine.

kombiniere FF F P B = foldr (g F P B) [] FF.
    
g F P B Z BB = Z F P B ++ BB.
   

OPNS

keine, koenig, turm  :: figur.

EQNS

keine _ _ _ = [].

koenig 
  = kombiniere
   ([ein_schritt oben,
     ein_schritt unten,    
     ein_schritt rechts,    
     ein_schritt links,    
     ein_schritt (d oben  rechts),    
     ein_schritt (d oben  links ),    
     ein_schritt (d unten rechts),    
     ein_schritt (d unten links )]).
     
    
turm 
  = kombiniere
    ([in_richtung oben, 
      in_richtung unten,
      in_richtung rechts,
      in_richtung links]).

OPNS   

anfang :: brett.

EQNS

 anfang (p 1 1) = s schwarz koenig.
 anfang (p 1 2) = s schwarz turm.
 anfang (p 8 8) = s weiss koenig.
$anfang _       = leer.

OPNS 

goal:: system -> system.

EQNS

goal S = system(write(turm schwarz (p 1 1) anfang,S)).
 
END.              
