SPEC MASTERMIND = INTEGER + STREAM + LISTOPS +

SORTS is ::= [integer].
      iss ::= [is].

OPNS filter :: is -> iss -> integer -> integer -> iss.
EQNS filter _ [] _ _ = [].
     filter C (A:X) R P = if test C A R P then A:filter C X R P 
                                          else   filter C X R P.

OPNS   test :: is -> is -> integer -> integer -> boolean.
MACROS (#r,#x,#y) = place X Y.
EQNS   test X Y R I = if #r == R then inthere #x #y == I else false.
  
OPNS   place :: is -> is -> (integer,is,is).
MACROS (#i,#x,#y) = place X Y.
EQNS   place (A:X) (B:Y) = if A==B then (#i+1,  #x,  #y)
                                   else (#i  ,A:#x,B:#y).
      $place _ _ = (0,[],[]).

OPNS   inthere :: is -> is -> integer.
MACROS (#i,#y) = inthere A Y.
EQNS   inthere (A:X) Y = #i+inthere X #y.
       inthere [] _ = 0.

OPNS   inthere :: integer -> is -> (integer,is).
MACROS (#i,#x) = inthere I X.
EQNS   inthere _ [] = (0,[]).
       inthere I (A:X) = if I==A then (1,X)
                                 else (#i,A:#x). 

OPNS   gen :: integer -> integer -> integer -> integer -> iss.
EQNS   gen A B C D = [[A,B,C,D]
                     | if D==6
                       then if C==6
                            then if B==6
                                 then if A==6
                                      then []
                                      else gen (A+1) 1 1 1
                                 else gen A (B+1) 1 1
                            else gen A B (C+1) 1
                       else gen A B C (D+1)
                      ].

OPNS answer :: system -> (system,integer,integer).
MACROS (_,#r,#s1) = read(0,  S+"  X: ").
       (_,#p,#s2) = read(0,#s1+"           O: ").
       
EQNS answer S = (#s2,#r,#p).

OPNS goal :: system -> system.
EQNS goal S = guess 1 0 0 (gen 1 1 1 1) (S+"Mastermind Guess V2.0\n"). 

OPNS takeone :: integer -> iss -> is.
EQNS takeone _ [] = [].
     takeone _ [A] = A.
    $takeone I IS = if length IS < I then takeone (I-length IS) IS
                else  IS!I.
                
SORTS info ::= [integer].
OPNS add::(integer,integer) -> info -> info.
EQNS 
  add XI [] = add XI [0].  
  add (X,I) [N|NN] =
    if I == 0
    then if X == 0
         then [N+1|NN]
         else [N|add (X-1,4 - (X-1)) NN]
    else [N|add (X,I-1) NN].
    
OPNS compare_all::iss -> iss -> integer -> (integer,is) -> is.
MACROS #D = deriv MEAN (split X ALL []).
EQNS
  compare_all [] _ _ (_,BEST) = BEST.
  compare_all [X|XX] ALL MEAN (D,BEST) =
    compare_all XX ALL MEAN (if #D < D then (#D,X) else (D,BEST)). 
    
OPNS deriv::integer -> info -> integer.
MACROS #d = MEAN - X.
EQNS
  deriv _ [] = 0.
  deriv MEAN [X|XX] = (#d * #d) + deriv MEAN XX.

OPNS split :: is -> iss -> info -> info.
MACROS (#X,#a,#b) = place X Y.
       #I = inthere #a #b.
EQNS split _ [] I = I.
     split X (Y:YY) I = split X YY (if #X == 4 then I else (add(#X,#I) I)).


OPNS guess :: integer -> integer -> integer -> iss -> system -> system.
     best_move :: integer -> integer -> integer -> iss -> is.
     
EQNS best_move N R P X =
          if N==1
            then [1,1,2,3]
            elsif N==2
            then case R of
                   4: [1,1,2,3]
                 | 3: [1,4,2,3] 
                 | 2: case P of
                       2:  [1,2,1,3]
                     | 1:  [1,4,1,3]
                      else [1,4,2,5]
                 | 1: case P of
                       3:  [1,2,3,1]
                     | 2:  [1,4,3,2]
                     | 1:  [1,4,1,5]
                      else [1,4,5,6]
                 else case P of
                       4:  [2,3,1,1]
                     | 3:  [2,4,3,1]
                     | 2:  [4,5,3,2]
                     | 1:  [2,4,4,5]
                      else [4,4,5,5]
            else compare_all X X (length X _div 13) (maxint,[]).
                 /** takeone 83 X. **/
                 
MACROS #A = best_move N R P X.
       (_,#s0) = write(length X,S+"Searchspace:").
       (_,#s1) = write(#A,#s0+"\n").
       (#s2,#r,#p) = answer #s1.
       #m = filter #A X #r #p.
       #l = guess (N+1) #r #p #m #s2.
EQNS guess _ _ _ [] S = S+"Na das war wohl nichts\n".
     guess _ _ _ [X] S = system(write(X,S+"Das ist sie: "))+"\n".
    $guess N R P X S = #l.                             
END.
