SPEC MINMAX =


FORMAL


 SORTS situation.
       move.
       moves ::= [move].
 
 OPNS all_moves:: situation -> moves.
      make_move:: situation -> move -> situation.
      value:: situation -> integer.
      no_move:: move.


GLOBAL


 SORTS lookahead ::= (integer).
       
 OPNS best_move:: situation -> lookahead -> move.



LOCAL

 INTEGER + FOLD + LISTOPS +

 
 SORTS minmax ::= minim | maxim.


 OPNS not:: minmax -> minmax.
 
 EQNS not minim = maxim.
      not maxim = minim.



 EQNS best_move Situation =
        find_best_move (all_moves Situation) (make_move Situation).
 
 
 OPNS find_best_move:: moves -> (move -> situation) -> lookahead -> move.
 
 MACROS #MoveValue = move_value minim (DoMove Move) LookAhead.
 
 EQNS find_best_move []     _ _ = no_move.
      find_best_move [Move] _ _ = Move.
     $find_best_move [Move|Moves] DoMove LookAhead =
        move (foldl (decide DoMove LookAhead) (Move,#MoveValue) Moves).

 
 OPNS decide:: (move -> situation) -> lookahead -> 
               (move,integer) -> move -> (move,integer).
 
 EQNS decide DoMove LookAhead (CurrMove,CurrMoveValue) Move =
        if #MoveValue > CurrMoveValue
        then (    Move,   #MoveValue)
        else (CurrMove,CurrMoveValue).



 OPNS move_value:: minmax -> situation -> lookahead -> integer.
   
 MACROS #all_moves = all_moves Situation.
        #value #M = move_value(not MinMax)(make_move Situation #M)(LookAhead-1).

 EQNS move_value MinMax Situation LookAhead = 
        if LookAhead <= 0
        then value Situation
        elsif #all_moves == []
        then value Situation
        else foldl (decide MinMax Situation LookAhead)
                   (#value (hd #all_moves)) 
                   (tl #all_moves).


 OPNS decide:: minmax -> situation -> lookahead ->
               integer -> move -> integer.
 
 EQNS decide MinMax Situation LookAhead Value Move =
         if (if MinMax == minim
             then #value Move < Value
             else #value Move > Value)
         then #value Move
         else Value.
END.
