SPEC MATRIX = 
  
  INTEGER +
  LISTS ACTUAL SORTS data=integer. list=row. lists=rows. END+
  READWRITE +
  
{FORMAL SORTS data.
GLOBAL}

SORTS 
  matrix ::= m(integer,integer,rows).
  row::= [integer].
  rows::= [row].
  
OPNS
  matrix * matrix :: (boolean,matrix).
  transpose:: (matrix) -> matrix.
  
LOCAL

OPNS
  mat_mult:: (rows,rows) -> rows.
  row_mult:: (row,rows) -> row.
  col_mult:: (row,row) -> integer.
  
EQNS
  m(N,M,ROWS) * m(N2,M2,ROWS2) =
    if M == N2
    then (true,m(N,M2,mat_mult(ROWS,transpose(ROWS2))))
    else (false,m(N,M,ROWS)).
    
  transpose(m(N,M,ROWS)) = m(M,N,transpose(ROWS)).
  
  mat_mult([],_) = [].
  mat_mult([R|ROWS],B) = [row_mult(R,B)|mat_mult(ROWS,B)].
  
  row_mult(_,[]) = [].
  row_mult(ROW,[COL|COLS]) = [col_mult(ROW,COL)|row_mult(ROW,COLS)].
  
 $col_mult(_,_) = 0.
  col_mult([D|DD],[D2|DD2]) = (D*D2) + col_mult(DD,DD2).

OPNS goal:: (system) -> system.
     gen:: (integer,integer) -> rows.
     gen:: (integer) -> row.
EQNS
  gen(I,N) = if I<= 0 then [] else [gen(N)|gen(I-1,N)].
  
  gen(I) = if I<= 0 then [] else [I|gen(I-1)].
      
MACROS #N=128.
      #A=m(#N,#N,gen(#N,#N)).
EQNS goal(S) = system(write(boolean(#A*#A),S)).

END.
