SPEC LR = INTEGER + STRING + SYSTEM + READWRITE + LISTOPS +
SORTS

  symbol ::= terminal    char 
	   | nonterminal char
	   .
  symbols ::= [symbol].
  values  ::= [value].
  strings ::= [string].
  sym_acts ::= [symbol->action].	    

  production ::= p(symbol, symbols).
/**  generation ::= g(values -> values). **/

  action ::=	shift (symbol -> action) |
		goto (symbol -> action)	|
		reduce (production, values -> values)	|
		error |			
		accept(values -> values).
		
  value  ::= v_expr expr.
  expr   ::=  c | expr + expr | expr * expr.

/* (Value-Stack,Zustands-Stack,Eingabe,Fehlermeldungen) */
  configuration  ::= c(vals::values,sym_acts,symbols,strings).

OPNS
  r0, r1, r2, r3, r4, r5, r6 :: production.

EQNS
r0 = p(nonterminal 's',[nonterminal 'e']).
r1 = p(nonterminal 'e',[nonterminal 'e', terminal '+', nonterminal 't']).
r2 = p(nonterminal 'e',[nonterminal 't']).
r3 = p(nonterminal 't',[nonterminal 't', terminal '*', nonterminal 'f']).
r4 = p(nonterminal 't',[nonterminal 'f']).
r5 = p(nonterminal 'f',[terminal '(', nonterminal 'e', terminal ')']).
r6 = p(nonterminal 'f',[terminal '1']).




OPNS
  g0, g1, g2, g3, g4, g5, g6, id :: values -> values.

EQNS
  id X = X.
  
  g0 = id.
  
  g1([v_expr X,v_expr Y|REST])	= [v_expr (Y + X)|REST].
 $g1 = id.
  
  g2 = id.
  
  g3([v_expr(A),v_expr B|REST]) = [v_expr (B * A)|REST].
 $g3 = id.
 
  g4 = id.
  
  g5 = id.
  
  g6 REST = [v_expr c|REST].

OPNS
  p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11 :: symbol -> action.
 
EQNS 
  p0 (terminal '1') = shift p1.
  p0 (terminal '(') = shift p2.
  p0 (nonterminal 'e') = goto p3.
  p0 (nonterminal 't') = goto p4.
  p0 (nonterminal 'f') = goto p5.
 $p0 _ = error.

  p1 (terminal '.') = reduce(r6,g6).
  p1 (terminal '+') = reduce(r6,g6).
  p1 (terminal '*') = reduce(r6,g6).
  p1 (terminal ')') = reduce(r6,g6).
 $p1 _ = error.

  p2 (terminal '1') = shift p1.
  p2 (terminal '(') = shift p2.
  p2 (nonterminal 'e') = goto p6.
  p2 (nonterminal 't') = goto p4.
  p2 (nonterminal 'f') = goto p5.
 $p2 _ = error.

  p3 (terminal '.') = accept g0.
  p3 (terminal '+') = shift p7.
 $p3 _ = error.

  p4 (terminal '.') = reduce(r2,g2).
  p4 (terminal '+') = reduce(r2,g2).
  p4 (terminal '*') = shift p8.
  p4 (terminal ')') = reduce(r2,g2).
 $p4 _ = error.

  p5 (terminal '.') = reduce(r4,g4).
  p5 (terminal '+') = reduce(r4,g4).
  p5 (terminal '*') = reduce(r4,g4).
  p5 (terminal ')') = reduce(r4,g4).
 $p5 _ = error.

  p6 (terminal '+') = shift p7.
  p6 (terminal ')') = shift p9.
 $p6 _ = error.

  p7 (terminal '1') = shift p1.
  p7 (terminal '(') = shift p2.
  p7 (nonterminal 't') = goto p10.
  p7 (nonterminal 'f') = goto p5.
 $p7 _ = error.

  p8 (terminal '1') = shift p1.
  p8 (terminal '(') = shift p2.
  p8 (nonterminal 'f') = goto p11.
 $p8 _ = error.

  p9 (terminal '.') = reduce(r5,g5).
  p9 (terminal '+') = reduce(r5,g5).
  p9 (terminal '*') = reduce(r5,g5).
  p9 (terminal ')') = reduce(r5,g5).
 $p9 _ = error.

  p10 (terminal '.') = reduce(r1,g1).
  p10 (terminal '+') = reduce(r1,g1).
  p10 (terminal '*') = shift p8.
  p10 (terminal ')') = reduce(r1,g1).
 $p10 _ = error.

  p11 (terminal '.') = reduce(r3,g3).
  p11 (terminal '+') = reduce(r3,g3).
  p11 (terminal '*') = reduce(r3,g3).
  p11 (terminal ')') = reduce(r3,g3).
 $p11 _ = error.

OPNS
  do_lr1 :: configuration -> configuration.
  do_lr11 :: action -> configuration -> configuration.
  
  
EQNS
  do_lr1(c(VS,PS,SYMS,MSGS)) = 
    do_lr11 ((hd PS) (hd SYMS)) (c(VS,PS,SYMS,MSGS)).


  do_lr11 (accept G) (c(VS,PS,SYMS,MSGS))
    = c(G VS,PS,SYMS,["accept"|MSGS]).

  do_lr11 error (c(VS,PS,SYMS,MSGS)) 
    = c(VS,PS,SYMS,["error"|MSGS]).

  do_lr11 (shift P) (c(VS,PS,SYMS,MSGS))
    = do_lr1(c(VS,[P|PS],tl SYMS,MSGS)).

  do_lr11 (goto P) (c(VS,PS,SYMS,MSGS))
    = do_lr1(c(VS,[P|PS],tl SYMS,MSGS)).

  do_lr11 (reduce(p(L,R),G)) (c(VS,PS,SYMS,MSGS))
    = do_lr1(c(G VS,drop (length R) PS,[L|SYMS],MSGS)).

OPNS
  terms :: string -> symbols.
  show:: values -> string.
  show:: expr -> string.
  
MACROS (#b,#c,#s) = frontchar S.
EQNS
  terms S =
    if #b
    then [terminal #c|terms #s]    
    else [].
    
  show([]) = "".
  show([v_expr X]) = show X.
 $show([v_expr N|L]) = show N + "\n" + show L.
 
  show c = "c".
  show(E1 + E2) = "(" + show E1 + "+" + show E2 + ")".
  show(E1 * E2) = "(" + show E1 + "*" + show E2 + ")".
    
OPNS
  goal:: (system) -> system.
  
MACROS (_,#input,#S) = file_string "lr.expr" S.
EQNS
  goal S =
    system(write_string(show(vals(do_lr1(c([],[p0],terms #input,[]))))) #S).

  {   system(write(vals(do_lr1(c([],[p0],terms #input,[]))),#S)).}
  
    

END.
