#define SCRFILE "/usr/pro/trawi/ATAXX.scr"
#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <pwd.h>

/* Repraesentation des Spielfelds */
#define WIDTH  7
#define HEIGHT 7
#define NUMSCORES 100

#define EMPTY  0
#define FULL   1
#define BLACK  2
#define WHITE  3

/* Definitionen der Figuren */
static short icon_image[] = {
#include "ATAXX.icon"
};

DEFINE_ICON_FROM_IMAGE(icon,icon_image);
static short aleer[] = {
#include "ATAXX.leer"
};
static short avoll[] = {
#include "ATAXX.voll"
};
static short aschwarz[] = {
#include "ATAXX.sw"
};
static short aweiss[] = {
#include "ATAXX.ws"
};
mpr_static(leer,64,64,1,aleer);
mpr_static(voll,64,64,1,avoll);
mpr_static(schwarz,64,64,1,aschwarz);
mpr_static(weiss,64,64,1,aweiss);
Pixrect *figures[] = 
   {&leer,&voll,&schwarz,&weiss};

TERM SITU,CSITU;
static Window frame;
static Canvas canvas;
static Panel panel;
static Textsw display;
static Panel_item msg_item,fn_item,name_item1,name_item2,color_item,score_item;
static Pixwin *pw;

typedef unsigned BOARD[WIDTH][HEIGHT];

/*** Anfangsstellungen ***/
#define NUMBOARDS 6
BOARD bb[] = 
          {{{2,0,0,0,0,0,3},
            {0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0},
            {0,0,0,0,0,0,0},
            {3,0,0,0,0,0,2}},
           {{2,0,1,1,1,0,3},
            {0,0,0,0,0,0,0},
            {1,1,0,0,0,1,1},
            {1,0,0,0,0,0,1},
            {1,1,0,0,0,1,1},
            {0,0,0,0,0,0,0},
            {3,0,1,1,1,0,2}},
           {{2,0,1,1,1,0,3},
            {0,0,0,0,0,0,0},
            {1,1,0,0,0,1,1},
            {0,0,0,1,0,0,0},
            {1,1,0,0,0,1,1},
            {0,0,0,0,0,0,0},
            {3,0,1,1,1,0,2}},
           {{2,0,0,0,0,0,3},
            {0,0,0,0,0,0,0},
            {0,0,0,1,0,0,0},
            {0,0,1,1,1,0,0},
            {0,0,0,1,0,0,0},
            {0,0,0,0,0,0,0},
            {3,0,0,0,0,0,2}},
           {{2,0,1,0,1,0,3},
            {0,1,0,0,0,1,0},
            {1,0,0,0,0,0,1},
            {0,0,0,0,0,0,0},
            {1,0,0,0,0,0,1},
            {0,1,0,0,0,1,0},
            {3,0,1,0,1,0,2}},
           {{2,0,0,1,0,0,3},
            {0,0,0,1,0,0,0},
            {0,0,0,0,0,0,0},
            {1,1,0,0,0,1,1},
            {0,0,0,0,0,0,0},
            {0,0,0,1,0,0,0},
            {3,0,0,1,0,0,2}}};

#define ATRUE 1
#define FALSE 0
#ifndef bool
typedef unsigned bool;
#endif

typedef struct{
  char name[30];
  unsigned level;
  } ENTRY;
  
ENTRY scores[NUMSCORES];

#define cp_sit copy_ATAXX_situation(CSITU)
#define EOG (ATAXXeog_0(cp_sit)==true)
#define mk_pos(x,y) co__ATAXXp_0((TERM)(x),(TERM)(y))
#define mk_move co__ATAXXm_0(mk_pos(XNOW,YNOW),mk_pos(XDEST,YDEST))

static int XNOW,YNOW,XDEST,YDEST,SELECTED=FALSE;

static void initscores(){
  unsigned i;
  for (i=0; i< NUMSCORES; i++)
    scores[i].level = 0;
}

static int enterscore(name,level) char *name; unsigned level; {
  unsigned i,j;
  int inx = -1;
  for (i=0; i< NUMSCORES; i++)
    if (inx < 0) {
      if (level > scores[i].level)  {
        for (j=NUMSCORES-1; j>i; j--) {
          strcpy(scores[j].name,scores[j-1].name);
          scores[j].level = scores[j-1].level;
        }
        strcpy(scores[i].name,name);
        scores[i].level = level;
        inx = i;
      }
    }
    else if (strcmp(name,scores[i].name) == 0) {
      for (j=i; j<NUMSCORES-1 && scores[j+1].level; j++) {
        strcpy(scores[j].name,scores[j+1].name);
        scores[j].level = scores[j+1].level;
      }
      if (j>=i) scores[j].level = 0;
    }
  return inx;
}

#define skip() while (((c=fgetc(fp)) != EOF && c <= ' '))
#define accept(ch) if ((c=fgetc(fp)) != ch) {res=FALSE; goto end;}
static bool loadscores(fn) char *fn;{
  FILE *fp;
  unsigned i,j,res=ATRUE;
  int c;

  if (!strlen(fn)) return FALSE;
  if ((fp=fopen(fn,"r"))==NULL) return FALSE;
  
  initscores();
  
  accept('[');
  for (i=0; i< NUMSCORES; i++) {
    accept('(');
    accept('\"');
    for (j=0; j<30 && (c=fgetc(fp))!='\"'; j++) scores[i].name[j] = c;
    scores[i].name[j] = '\0';
    if (c !='"') {res=FALSE; goto end;}
    accept(',');
    if (fscanf(fp,"%d",&(scores[i].level)) < 1) {res=FALSE; goto end;}
    accept(')');
    if (i < NUMSCORES-1) { 
      if ((c=fgetc(fp)) == ']') {res=ATRUE; goto end;}
      else if (c != ',') {res=FALSE; goto end;}
    }
  }
  accept(']');
end:
  fclose(fp);
  return res;
}

static bool savescores(fn) char *fn;{
  FILE *fp;
  unsigned i;

  if (!strlen(fn)) return FALSE;
  if (access(fn,0)==0) {char backupfn[256];
    sprintf(backupfn,"%s%%",fn);
    if (rename(fn,backupfn)) return FALSE;
  }
  if ((fp=fopen(fn,"w"))==NULL) return FALSE;

 flock(fileno(fp),2); /* exclusive lock */
   
  putc('[',fp);
  for (i=0; i< NUMSCORES && scores[i].level; i++) {
    fprintf(fp,"(\"%s\",%d)",scores[i].name,scores[i].level) ;
    if (i < NUMSCORES-1 && scores[i+1].level) fputc(',',fp);
  }
  fputc(']',fp);

  flock(fileno(fp),8); /* unlock */

  fclose(fp);
 
  return ATRUE;
}

/* Initialisierung eines Spielfelds */
static void initboard() {
  unsigned x,y; TERM CPOS;
  unsigned bn = random() % NUMBOARDS;
  free_ATAXX_situation(CSITU);
  CSITU=copy_ATAXX_situation(SITU);
  for (x=0; x < WIDTH; x++)
    for (y=0; y < HEIGHT; y++)
      { CPOS = mk_pos(x,y);
        switch(bb[bn][x][y]) {
        case 0: CSITU = ATAXXput_stone_0(CSITU,CPOS,co__ATAXXnone_0);break;
        case 1: CSITU = ATAXXput_stone_0(CSITU,CPOS,co__ATAXXobstacle_0);break;
        case 2: CSITU = ATAXXput_stone_0(CSITU,CPOS,co__ATAXXwhite_0);break;
        case 3: CSITU = ATAXXput_stone_0(CSITU,CPOS,co__ATAXXblack_0);break;
}     } }

/* I/O */
static void msg(s) char *s; {
  panel_set(msg_item,PANEL_LABEL_STRING,s,0);
}

static void show_color() {
  if (ATAXXwhites_move_0(cp_sit)==true)
    panel_set(color_item,PANEL_LABEL_IMAGE,figures[2],0);
  else
    panel_set(color_item,PANEL_LABEL_IMAGE,figures[3],0);
}

static void show_score() {
  TERM black,white;
  char s[20];
  
  ATAXXscore_0(cp_sit,&black,&white);
  sprintf(s,"%2d : %2d",(int)black,(int)white);
  panel_set(score_item,PANEL_LABEL_STRING,s,0);
}

static char *current_fn(){
  return (char *)panel_get_value(fn_item);
}

static bool computer() {
  if (ATAXXwhites_move_0(cp_sit)==true)
    return (strcmp((char *)panel_get_value(name_item1),"Computer") == 0);
  else
    return (strcmp((char *)panel_get_value(name_item2),"Computer") == 0);
}

static void showscores(inx) int inx; {
  unsigned i,start,stop;
  FILE *fp;

  if ((fp=fopen("/tmp/ATAXX.txt","w"))==NULL) 
    { msg("Error creating tmpfile"); return; }
  
  for (i=0; i< NUMSCORES && scores[i].level; i++) {
    fprintf(fp,"%3d %-15s : %6d\n",i+1,scores[i].name,scores[i].level);
  }
  fclose(fp);
  
  window_set(display,TEXTSW_FILE,"/tmp/ATAXX.txt",0);
  start=textsw_index_for_file_line(display,inx);
  stop=textsw_index_for_file_line(display,inx+1);
  textsw_set_selection(display,start,stop,1);
  textsw_possibly_normalize(display,start);
}

static void fshow(X,Y,F) unsigned X,Y; TERM F; { unsigned ff=0;
  switch(OPN(F)){
   case _CATAXXobstacle_0: ff=1;break;
   case _CATAXXwhite_0:    ff=2;break;
   case _CATAXXblack_0:    ff=3;break;
  }
  pw_write(pw,X*64,Y*64,64,64,PIX_SRC,figures[ff],0,0);
} /** fshow **/

static void showboard() {
  unsigned x,y;

  for (y=0; y<HEIGHT; y++)
    for (x=0; x<WIDTH; x++)
     fshow(x,y,ATAXXget_stone_0(cp_sit,mk_pos(x,y)));
} /** showboard **/


#define MOVE   0
#define SELECT 1


static void computer_move() {
  TERM BESTMOVE;
  BESTMOVE = ATAXXbest_move_0(cp_sit,(TERM)1);
  XNOW =(int)BESTMOVE->ARGS[0]->ARGS[0];
  YNOW =(int)BESTMOVE->ARGS[0]->ARGS[1];
  XDEST=(int)BESTMOVE->ARGS[1]->ARGS[0];
  YDEST=(int)BESTMOVE->ARGS[1]->ARGS[1];
  free_ATAXX_move(BESTMOVE);
}

static void handle_key(KEY) unsigned KEY; {
handle_loop:
  msg("");
  switch (KEY) {
    case MOVE:
      if EOG 
        msg("End of game");
      else {
        if (computer()) computer_move();
        SELECTED=FALSE;
        if (ATAXXcorrect_0(cp_sit,mk_move)!=true)
           msg("Illegal move"); 
        else {
           CSITU = ATAXXmake_move_0(CSITU,mk_move);
           showboard();
           if EOG {
              CSITU = ATAXXfillup_0(CSITU);
              showboard();
              show_score();
              msg("End of game");
           } else {
              show_color();
              show_score();
              if (computer()) { KEY=MOVE; goto handle_loop; }
           }
      } }
      break;
    case 'r': /* Restart */
      msg("");
      initboard();
      showboard();
      SELECTED=FALSE;
      show_color();
      show_score();
      if (computer()) { KEY=MOVE; goto handle_loop; }
      break;
    case 'l': /* Load scores */
      if (!loadscores(current_fn())) {
        msg("Error loading scores");
        initscores();
      }
      showscores();
      break;
    default:
      msg("Invalid key");
      break;
  }
} /** handle_key **/

static void canvas_input(canvas,event,arg) 
  Canvas canvas; Event *event; caddr_t arg; {
  
  switch (event_id(event)) {
    case MS_LEFT: 
      if event_is_down(event) { /* Enter */
        if (SELECTED) {
          XDEST = min(event_x(event) / 64,WIDTH-1);
          YDEST = min(event_y(event) / 64,HEIGHT-1);
          handle_key(MOVE);
        }
        else {
          XNOW = min(event_x(event) / 64,WIDTH-1);
          YNOW = min(event_y(event) / 64,HEIGHT-1);
          SELECTED=ATRUE;
        }
        return;
      }
    default: break;
  }
  window_default_event_proc(canvas,event,arg);
}

static void restart(){ handle_key('r'); }
static void load()   { handle_key('l'); }

static void create_panel_items(player,fn) char *player,*fn; {
  fn_item = panel_create_item(panel,PANEL_TEXT,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(0),
                    PANEL_VALUE_DISPLAY_LENGTH,31,
                    PANEL_LABEL_STRING,"Scorefile:",
                    PANEL_VALUE,strlen(fn)?fn:SCRFILE,
                    0);
  name_item1 = panel_create_item(panel,PANEL_TEXT,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(1),
                    PANEL_VALUE_DISPLAY_LENGTH,31,
                    PANEL_LABEL_STRING,"Player1:",
                    PANEL_VALUE,strlen(player)?player:
                      getpwuid(getuid())->pw_name,
                    0);
  name_item2= panel_create_item(panel,PANEL_TEXT,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(2),
                    PANEL_VALUE_DISPLAY_LENGTH,31,
                    PANEL_LABEL_STRING,"Player2:",
                    PANEL_VALUE,strlen(player)?player:
                      getpwuid(getuid())->pw_name,
                    0);
  panel_create_item(panel,PANEL_BUTTON,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(3),
                    PANEL_LABEL_IMAGE,panel_button_image(panel,"Restart",0,0),
                    PANEL_NOTIFY_PROC,restart,
                    0);  
  panel_create_item(panel,PANEL_BUTTON,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(4),
                    PANEL_LABEL_IMAGE,panel_button_image(panel,"Load scores",0,0),
                    PANEL_NOTIFY_PROC,load,
                    0);  
  msg_item = panel_create_item(panel,PANEL_MESSAGE,
                    PANEL_LABEL_X,ATTR_COL(0),
                    PANEL_LABEL_Y,ATTR_ROW(5),
                    PANEL_VALUE_DISPLAY_LENGTH,31,
                    0);
  score_item = panel_create_item(panel,PANEL_MESSAGE,
                    PANEL_LABEL_X,ATTR_COL(28),
                    PANEL_LABEL_Y,ATTR_ROW(4),
                    PANEL_VALUE_DISPLAY_LENGTH,31,
                    0);
  color_item = panel_create_item(panel,PANEL_MESSAGE,
                    PANEL_LABEL_X,ATTR_COL(18),
                    PANEL_LABEL_Y,ATTR_ROW(3),
                    PANEL_LABEL_IMAGE,figures[2],
                    0);  
  msg("");
}

TERM xx_ATAXXrun_0(S,sys) TERM S,sys; {
  CSITU=copy_ATAXX_situation(S);
  SITU=S;

  frame = window_create(NULL,FRAME,
                        FRAME_LABEL,"Ataxx V1.0 by Ric&JvH 91/05",
                        FRAME_ICON,&icon,
                        0);

  canvas = window_create(frame,CANVAS,
                         WIN_WIDTH,WIDTH*64,
                         WIN_HEIGHT,HEIGHT*64,
                         WIN_EVENT_PROC,canvas_input,
                         0); 
  pw = (Pixwin *)canvas_pixwin(canvas);

  panel = window_create(frame,PANEL,
                        WIN_ROWS,6,
                        WIN_COLUMNS,39,
                        0);     
  
  display = window_create(frame,TEXTSW,
                        WIN_COLUMNS,39,
                        WIN_BELOW,panel,
                        WIN_RIGHT_OF,canvas,
                        TEXTSW_BROWSING,ATRUE,
                        TEXTSW_DISABLE_LOAD,ATRUE,
                        TEXTSW_READ_ONLY,ATRUE,
                        TEXTSW_IGNORE_LIMIT,TEXTSW_INFINITY,
                        0);
  create_panel_items("",""); 

/**  window_fit(panel); **/
  window_fit(frame);
  
  load();
  restart();

  window_main_loop(frame);
  
  free_ATAXX_situation(S);
  return sys;	 
}

unsigned __XINIT_ATAXX = 0;
ATAXX_Xinitialize(){if(__XINIT_ATAXX == 0) __XINIT_ATAXX = 1;}
