SPEC XARRAY ={
FORMAL SORTS data.
GLOBAL
SORTS xarray.
OPNS
  create_array:: (integer,data) -> (boolean,xarray).
  size:: (xarray) -> integer.
  assign:: (integer,data,xarray) -> (boolean,xarray).
  value:: (integer,data,xarray) -> (boolean,data).
  
LOCAL
  ARRAY ACTUAL SORTS data=data. END +
  ARRAY ACTUAL SORTS data=array. array=yarray. END +
  
SORTS xarray ::= x(integer,yarray).

MACROS (#B0,#A)=create_array(0,D).
       (#B1,#X0)=create_array(N _div maxsize + min(1,N _mod maxsize),#A).
      
EQNS
  create_array(N,D) =
    if N > (maxsize * maxsize)
    then (false,x(0,yarray(create_array(0,#A))))
    else (#B0 and #B1,x(N,init(0,N,D,#X))).
    
  init(I,N,D,X) =
    if N-maxsize < 0
    then yarray(assign(I,array(create_array(N,D))))
    else init(I+1,N-maxsize,D,yarray(assign(I,array(create_array(maxsize,D))))).
    
  size(x(N,_)) = N.
  
MACROS
  #AI = I _mod N.
  #XI = I _div N.
  (#B0,#A)=assign(#AI,D,data(value(#XI,array(create_array(0,D)),X))).
  (#B1,#X)=assign(#XI,#A,X).
EQNS
  assign(I,D,x(N,X)) = 
    if I < N then (#B0 and #B1,x(N,#X))
    else (false,x(N,X)).
  
MACROS 
  #AI = I _mod N.
  #XI = I _div N.
  (#B1,#A)=value(#XI,array(create_array(0,D)),X).
  (#B0,#D)=value(#AI,D,#A).
EQNS
  value(I,D,x(N,X)) = 
    if I < N then (#B0 and #B1,#D)
    else (false,D).
  
}
  
END.
