SPEC WRITE =
{
FORMAL SORTS term.

GLOBAL 

OPNS
  rwrite:: (term,system) -> (boolean,system).


LOCAL
  TERM ACTUAL SORTS term = term. END +
  SORT ACTUAL SORTS data = term. END +
  STREAM +

EQNS
  rwrite (T,S) = rwrite (sort T) (unify T,S).

OPNS
  rwrite:: x_sort -> (x_term,system) -> (boolean,system).

MACROS
  (_,#cons ) = getcons Sort (opn Term).
  (_,#cons0) = getcons Sort 0.
  #ib        = (true,false,false,false).

EQNS
  rwrite Sort (Term,Sys) = 
    if is_functional Sort
    then (true,Sys + "(function)")
    elsif is_extern Sort
    then (true,Sys + "(extern)")
    elsif is_dynamic Sort
    then rwrite (type #cons0) #ib Term 0 Sys
    else rwrite (type #cons ) #ib Term 0 (Sys + (name #cons)).

OPNS
  rwrite:: type -> (boolean,boolean,boolean,boolean) ->
           x_term -> integer -> system -> (boolean,system).

MACROS
  (#ok,#s) = rwrite Sort (arg T Sort I,S+(if NeedPar then "(" else "")).

EQNS
  rwrite (c Sort) (First,InFunc,_,NeedPar) T I S =
      if First  then (true,S)
   elsif InFunc then (true,S)
   else if #ok
        then (#ok,#s+(if NeedPar then ")" else ""))
        else (#ok,#s).
  rwrite (t Sorts) (_,InFunc,_,_) T I S
}
END.
