SPEC STRING =
  BOOLEAN +
  INTEGER +
  CHAR +
  
SORTS 
{ EXTERN string ::= [char]. }

OPNS
        mt            :: string.
 EXTERN char : string :: string.

EQNS
  [] = "".

OPNS
 { Some opns of the standard set of listops rewritten for strings }

 EXTERN length :: string -> integer.
 
        string ! integer :: char.
        
        string ++ string :: string.
        
        hd :: string -> char.
        tl :: string -> string.
        
        init :: string -> string.
        last :: string -> char.
        
        drop :: integer -> string -> string.

        take :: integer -> string -> string.

        postfix :: char -> string -> string.
  
        rep :: integer -> char -> string.
  
        member :: string -> char -> boolean.

 { more opns }
 
 EXTERN compare :: string -> string -> integer.
 
        string <  string,
        string <= string,
        string >  string,
        string >= string :: boolean.

 EXTERN string + string :: string.
 
 EXTERN frontchar   :: string -> (boolean,char,string).
 EXTERN head        :: string -> (boolean,char).
 EXTERN frontstring :: integer -> string -> (boolean,string,string).
 
 EXTERN hash :: string -> integer.
 
        char_string :: char -> string.

LOCAL
  ERROR +
  
THEOREMS
{ length [] = 0.             }
{ length (_:X) = 1+length X. }

FORALL S::string.
EQNS
  S ! N = if boolean(frontchar S)
          then if N==0 then char(frontchar S)
                       else string(frontchar S)!(N-1)
          else error "subscript out of range".
                       
  (++) = (+).
  
  hd S = if boolean(head S)
         then char(head S)
         else error "hd \"\"".
  
  tl S = if boolean(frontchar S)
         then string(frontchar S)
         else error "tl \"\"".
  
  init S = if boolean(frontstring(length S) S)
           then string(frontstring(length S) S)
           else error "init \"\"".
  
  last S = if boolean(frontstring(length S) S)
           then hd(string(frontstring(length S) S))
           else error "last \"\"".

MACROS
  (#ok,#take,#drop) = frontstring N S.
  
EQNS 
  drop N S = if #ok then #drop else "".
  
  take N S = if #ok then #take else "".

EQNS  
  postfix C S = S ++ [C].
  
  (rep N C)::string = if N <= 0 then [] else C:rep(N-1) C.

  member S B = if boolean(frontchar S)
               then if char(frontchar S)==B
                    then true
                    else member (string(frontchar S)) B
               else false.

THEOREMS
{ compare []    []    =  0.                           }
{ compare (_:_) []    =  1.                           }
{ compare []    (_:_) = -1.                           }
{ compare (A:X) (B:Y) =                               }
{   if A<B then -1 elsif A>B then 1 else compare X Y. }

FORALL S1,S2::string.
EQNS
  S1 <  S2 = compare S1 S2 <  0.
  S1 <= S2 = compare S1 S2 <= 0.
  S1 >  S2 = compare S1 S2 >  0.
  S1 >= S2 = compare S1 S2 >= 0.

THEOREMS
{ []    + Y = Y.       }
{ (A:X) + Y = A:(X+Y). }

{ frontchar []    = (false,' ',[]).  }
{ frontchar (A:X) = (true,A,X).      }

{ head S = (boolean(frontchar S),char(fronchar S)). }

MACROS 
  (#ok,#fs,#rs) = frontstring (N-1) X.

THEOREMS
{ frontstring N []    = (N==0,[],[]).          }
{ frontstring N (A:X) = if N<=0                }
{                       then (N==0,[],X)       }
{                       else (#ok, A:#fs,#rs). }


{ hash [] = 0.                           }
{ hash (A:X) = char_integer C + hash S.  }

EQNS 
  char_string C = C:"".

END.
