SPEC REAL =

SORTS EXTERN real.

OPNS  EXTERN mk :: string  -> real.
      EXTERN mk :: real    -> string.
      EXTERN mk :: integer -> real.

OPNS  EXTERN real + real :: real.
      EXTERN real - real :: real.
      EXTERN real * real :: real.
      EXTERN real / real :: real.
      
      EXTERN negate :: real -> real.

OPNS  EXTERN real <   real :: boolean.
      EXTERN real <=  real :: boolean.
      EXTERN real >   real :: boolean.
      EXTERN real >=  real :: boolean.

LOCAL 

 SYSTEM +
 STRING +
 CHAR_UTIL +
 
OPNS 
  valid_real_char:: (char,boolean) -> boolean.

EQNS
  valid_real_char(C,PKT) = digit C || (C=='.' && not PKT).
    
OPNS 
  read_real_str:: (system,string,boolean) -> (boolean,string,system).

MACROS
  (#okchar,#char,#sys) = read_char SYS.
  (_,#undo) = unread_char #char #sys.
  
EQNS
  read_real_str(SYS,STR,PKT) = 
    if #okchar
    then if valid_real_char(#char,PKT)
         then read_real_str(#sys,STR+char_string #char,#char=='.' || PKT)
         else (not(STR==""),STR,#undo)
    else (not(STR==""),STR,#sys).
                               
OPNS 
  read_real:: system -> (boolean,real,system).
  
MACROS 
  (#ok,#str,#sys) = read_real_str(S,"",false).
  
EQNS 
  read_real S = (#ok,mk #str,#sys).

OPNS
  write_real:: (system,real) -> system.

EQNS
  write_real(S,R) = system(write_string(mk R) S).
  
END.
