SPEC RATIONAL =
{
SORTS rational.


OPNS  rational + rational -> (boolean,rational).
      rational - rational -> (boolean,rational).
      rational * rational -> (boolean,rational).
      rational / rational -> (boolean,rational).
      
      (boolean,rational) + (boolean,rational) -> (boolean,rational).
      (boolean,rational) - (boolean,rational) -> (boolean,rational).
      (boolean,rational) * (boolean,rational) -> (boolean,rational).
      (boolean,rational) / (boolean,rational) -> (boolean,rational).
      
      rational <   rational -> boolean.
      rational >   rational -> boolean.
      rational <=  rational -> boolean.
      rational >=  rational -> boolean.
      rational === rational -> boolean.
      !  : integer  -> rational.
      -  : rational -> rational.
      abs: rational -> rational.
      sin: rational -> rational.
      cos: rational -> rational.
      pi : rational.
      precision : rational.
      
LOCAL INTEGER + INTEGER_UTIL +
  
SORTS rational <- integer//integer.

EQNS (OK1,V1) + (OK2,V2) = if OK1 and OK2 then V1+V2 else (false,0).
     (OK1,V1) - (OK2,V2) = if OK1 and OK2 then V1-V2 else (false,0).
     (OK1,V1) * (OK2,V2) = if OK1 and OK2 then V1*V2 else (false,0).

MACROS (#ok1,#c1) = (X*Y)+(U*Y).
       (#ok2,#c2) = (X*Y)-(U*Y).
       (#ok3,#c3) = (X*U).
       (#ok4,#c4) = (X*V).
       (#ok5,#c5) = (Y*V).
       (#ok6,#c6) = (Y*U).
      
EQNS  (X//Y) + (U//V) = (#ok1 and #ok5,norm(#c1//#c5)).
      (X//Y) - (U//V) = (#ok2 and #ok5,norm(#c2//#c5)).
      (X//Y) * (U//V) = (#ok3 and #ok5,norm(#c3//#c5)).
      (X//Y) / (U//V) = (#ok4 and #ok6,norm(#c4//#c6)).
      
      
      -(X//Y) = -(X)//Y.

EQNS  sin(X) = if X <= (0//1)      then sin(X+((2//1)*pi))
            elsif X <= (1//2) * pi then sin_((0//1),X,0,X)
            elsif X <  pi          then sin(pi-X)
            elsif X <  (3//2) * pi then -(sin(X - pi))
            elsif X <  (2//1) * pi then -(sin((2//1)*pi-X))
            else                        sin(X-(2//1)*pi).
      cos(X) = sin(X+((1//2) * pi)).
      
OPNS  sin_ : (rational,rational,integer,rational) -> rational.

MACROS #z = -(A)*X*X.
       #n = (2*N+2)*(2*N+3).
       #sa
EQNS  sin_(S,X,N,A) = 
         if 
         else sin1(S+A,X,N+1,#z / !(#n)).

EQNS  pi = 22//7.
      precision = 1//maxint.
      
OPNS  norm: rational -> rational.

MACROS #u = if Y<0 then -(X) else X.
       #v = abs(Y).
       #d = gcd(#u,#v).
      
EQNS  norm(X//Y) = if Y == 0 
                   then (X//Y)
                   else ((#u div #d) //(#v div #d)).


OPNS  gcd: (integer,integer) -> integer.

EQNS  gcd(N,M) =    if N<M then gcd(N,M-N)
                 elsif M<N then gcd(N-M,M)
                 else           N.
}                 
END.
