SPEC LISTS = 

FORMAL 
  SORTS data. list ::= [data]. lists ::= [list].

GLOBAL 

OPNS
  flatten :: lists -> list.
  blow :: list -> lists.
  append_to_all :: lists -> data -> lists.
  concat_to_all :: lists -> list -> lists.
  insert_all :: data -> lists -> lists.
  first_col :: lists -> (list,lists).
  transpose :: lists -> lists.
  join :: list -> lists -> lists.
  
LOCAL
  LISTOPS ACTUAL SORTS data=data. list=list.  END+
  LISTOPS ACTUAL SORTS data=list. list=lists. END+
  
EQNS
 $flatten _ = [].
  flatten (A:X) = A ++ flatten X.

  blow [] = [].
  blow (A:X) = [A]:blow X.
  
  append_to_all [] _ = [].
  append_to_all (A:X) Y = postfix Y A:append_to_all X Y.

  concat_to_all [] _ = [].
  concat_to_all (A:X) Y = (A++Y):concat_to_all X Y.

  insert_all _ [] = [].
  insert_all A (B:Y) = (A:B):insert_all A Y.

MACROS
  (#D,#L) = first_col Y.
  
EQNS 
 $first_col _ = ([],[]).
  first_col ((A:X):Y) = (A:#D,X:#L).
  
  transpose [] = [].
  transpose (A:X) = join A (transpose X).
  
  join [] Y = Y.
  join (A:X) [] = [A]:join X [].
  join (A:X) (B:Y) = (A:B):join X Y.
  
END.
