SPEC GRAPH = { undirected graph }
  
FORMAL 

SORTS  node.  edge.

GLOBAL

  LIST ACTUAL SORTS data=node.    list=nodes.    END+
  LIST ACTUAL SORTS data=edge.    list=edges.    END+
  LIST ACTUAL SORTS data=integer. list=integers. END+
  LIST ACTUAL SORTS data=conn.    list=conns.    END+


SORTS
  graph ::= c(grap       ::integer,
              nodelist   ::nodes,
              edgelist   ::edges,
              connections::conns).
  conn  ::= c(from       ::integer, 
              label      ::integer, 
              to         ::integer).

  
OPNS
  mt :: graph.
  new_node :: (node,graph) -> (boolean,graph).
  new_edge :: (node,node,edge,graph) -> (boolean,graph).
  delete_node :: (node,graph) -> (boolean,graph).
  delete_edge :: (node,node,graph) -> (boolean,graph).
  set_grap :: (node,graph) -> (boolean,graph).
  
  connections :: (node,graph) -> nodes.
  exists :: (node,graph) -> boolean.
  connected :: (node,node,graph) -> boolean.
  grap :: (node,graph) -> (boolean,node).
  edge :: (node,node,edge,graph) -> (boolean,edge).
  walk :: (node,graph) -> (boolean,graph).
  
LOCAL
  FILTER +
  MAP +
  LOGIC +
  
OPNS
  get_conn :: (node,node,graph) -> conn.
  get_conn :: (integer,integer,graph) -> conn.
  index :: (node,graph) -> integer.
  index :: (edge,graph) -> integer.
  all_conns :: (integer,conns) -> integers.
  to_nodes :: (integers,graph) -> nodes.
  rename_nodes :: (integer,graph) -> graph.
  rename_node :: integer -> conn -> conn.
  kill_edge :: (integer,integer,graph) -> graph.
  is_edge :: (integer,integer) -> conn -> boolean.
  
EQNS
  [] = c(-1,[],[],[]).
  
  new_node(Node,Graph) =
    if exists(Node,Graph)
    then (false,Graph)
    else (true,nodelist(Graph,postfix Node (nodelist Graph))).

MACROS
  #from  = index(From,Graph).
  #edge  = index(Edge,Graph).
  #to    = index(To,Graph).
  #conn1 = c(#from,#edge,#to).
  #ngraph= edgelist(Graph,postfix Edge (edgelist Graph)).
  #nedge = index(Edge,#ngraph).
  #conn2 = c(#from,#nedge,#to).
  
EQNS  
  new_edge(From,To,Edge,Graph) =
    if (exists(From,Graph) && exists(To,Graph))
    then (true,
          if member (edgelist Graph) Edge
          then connections(Graph,[#conn1] ++ connections Graph)
          else connections(#ngraph,[#conn2] ++ connections #ngraph))
    else (false,Graph).
  
  delete_node(Node,Graph) =
    if (exists(Node,Graph) && (connections(Node,Graph)==[]))
    then (true,rename_nodes(index(Node,Graph),
                            nodelist(Graph,nodelist Graph--[Node])))
    else (false,Graph).
  
  delete_edge(From,To,Graph) =
    if connected(From,To,Graph)
    then (true,kill_edge(index(From,Graph),index(To,Graph),Graph))
    else (false,Graph).
       
  set_grap(Node,Graph) =
    if exists(Node,Graph)
    then (true,grap(Graph,index(Node,Graph)))
    else (false,Graph).
    
  connections(Node,Graph) =
    if exists(Node,Graph)
    then to_nodes(all_conns(index(Node,Graph),connections Graph),Graph)
    else [].
  
  exists(Node,Graph) = member (nodelist Graph) Node.
  
  connected(From,To,Graph) =
    if (exists(From,Graph) && exists(To,Graph))
    then exist (is_edge(index(From,Graph),index(From,Graph)))
               (connections Graph)
    else false.
    
  grap(Err,Graph) =
    if grap Graph== -1
    then (false,Err)
    else (true,nodelist Graph!grap Graph).
    
  edge(From,To,Err,Graph) =
    if connected(From,To,Graph)
    then (true,edgelist Graph!(label(get_conn(From,To,Graph))))
    else (false,Err).

EQNS    
  walk(Node,Graph) =
    if connected(nodelist Graph!grap Graph,Node,Graph)
    then set_grap(Node,Graph)
    else (false,Graph).

EQNS
  get_conn(From,To,Graph) = get_conn(index(From,Graph),index(To,Graph),Graph).

FORALL get_conn:: (integer,integer,graph) -> conn.
EQNS
  get_conn(From,To,c(G0,G1,G2,[C|More])) =
    if is_edge(From,To) C then C else get_conn(From,To,c(G0,G1,G2,More)).
 $get_conn _ = c(-1,-1,-1).

EQNS
  index(Node,c(_,Nodes,_,_)) = idx Nodes Node. 
     
  index(Edge,c(_,_,Edges,_)) = idx Edges Edge. 
  
  all_conns(_,[]) = [].
  all_conns(Node,[c(F,_,T)|More]) = 
    if Node==F
    then [T] ++ all_conns(Node,More)
    elsif Node==T
    then [F] ++ all_conns(Node,More)
    else all_conns(Node,More).
  
 $to_nodes(_,_) = [].
  to_nodes([N|NS],c(G0,[Node|Nodes],G2,G3)) =
    [[Node|Nodes]!N|to_nodes(NS,c(G0,[Node|Nodes],G2,G3))].
  
  rename_nodes(Killed,c(Grap,Nodes,Edges,Conns)) =
    c(if Grap>Killed then Grap-1 else Grap,
      Nodes,
      Edges,
      map (rename_node Killed) Conns).
  
  rename_node Killed (c(F,L,T)) =
    c(if F>Killed then F-1 else F,L,if T>Killed then T-1 else T).
    
  kill_edge(From,To,c(Grap,Nodes,Edges,Conns)) =
    c(Grap,Nodes,Edges,remove (is_edge(From,To)) Conns).
    
  is_edge(From,To)(c(F,_,T)) = ((From==F) && (To==T)) || ((From==T) && (To==F)).
  
END.
